/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs;

import java.util.Comparator;
import lombok.Generated;
import nbbrd.heylogs.spi.Forge;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.Versioning;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Resource {
    @lombok.NonNull
    private final String type;
    @lombok.NonNull
    private final String category;
    @lombok.NonNull
    private final String id;
    @lombok.NonNull
    private final String name;
    static final Comparator<Resource> DEFAULT_COMPARATOR = Comparator.comparing(Resource::getType).thenComparing(Resource::getCategory).thenComparing(Resource::getId);

    static Resource of(Rule rule) {
        return Resource.builder().type("rule").category(rule.getRuleCategory()).id(rule.getRuleId()).name(rule.getRuleName()).build();
    }

    static Resource of(Format format) {
        return Resource.builder().type("format").category(format.getFormatCategory()).id(format.getFormatId()).name(format.getFormatName()).build();
    }

    static Resource of(Versioning versioning) {
        return Resource.builder().type("versioning").category("main").id(versioning.getVersioningId()).name(versioning.getVersioningName()).build();
    }

    static Resource of(Forge forge) {
        return Resource.builder().type("forge").category("main").id(forge.getForgeId()).name(forge.getForgeName()).build();
    }

    @Generated
    Resource(@lombok.NonNull String type, @lombok.NonNull String category, @lombok.NonNull String id, @lombok.NonNull String name) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.type = type;
        this.category = category;
        this.id = id;
        this.name = name;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @lombok.NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @lombok.NonNull
    @Generated
    public String getCategory() {
        return this.category;
    }

    @lombok.NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "Resource(type=" + this.getType() + ", category=" + this.getCategory() + ", id=" + this.getId() + ", name=" + this.getName() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String type;
        @Generated
        private String category;
        @Generated
        private String id;
        @Generated
        private String name;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder type(@lombok.NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @NonNull Builder category(@lombok.NonNull String category) {
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            this.category = category;
            return this;
        }

        @Generated
        public @NonNull Builder id(@lombok.NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public @NonNull Builder name(@lombok.NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Resource build() {
            return new Resource(this.type, this.category, this.id, this.name);
        }

        @Generated
        public @NonNull String toString() {
            return "Resource.Builder(type=" + this.type + ", category=" + this.category + ", id=" + this.id + ", name=" + this.name + ")";
        }
    }
}

