/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import nbbrd.heylogs.spi.Forge;

public final class ForgeLoader {
    public static final Pattern ID_PATTERN = Pattern.compile("^[a-z0-9]+(?:-[a-z0-9]+)*$");
    private final Iterable<Forge> source = ServiceLoader.load(Forge.class);
    private final Predicate<Forge> filter = o -> ID_PATTERN.matcher(o.getForgeId()).matches();
    private final List<Forge> resource = this.doLoad();

    private List<Forge> doLoad() {
        return StreamSupport.stream(this.source.spliterator(), false).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<Forge> get() {
        return this.resource;
    }

    public static List<Forge> load() {
        return new ForgeLoader().get();
    }
}

