/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import nbbrd.heylogs.spi.ForgeLink;
import nbbrd.heylogs.spi.ForgeRef;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.heylogs.spi.RuleSeverity;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ForgeRefRuleSupport<L extends ForgeLink, R extends ForgeRef<L>>
implements Rule {
    @lombok.NonNull
    private final String id;
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final String category;
    @lombok.NonNull
    private final Predicate<Properties> availability;
    @lombok.NonNull
    private final RuleSeverity severity;
    @lombok.NonNull
    private final Function<? super CharSequence, L> linkParser;
    @lombok.NonNull
    private final Function<? super CharSequence, R> refParser;
    @lombok.NonNull
    private final Predicate<L> linkPredicate;
    @lombok.NonNull
    private final BiFunction<L, R, String> message;

    @Override
    @lombok.NonNull
    public String getRuleId() {
        return this.id;
    }

    @Override
    @lombok.NonNull
    public String getRuleName() {
        return this.name;
    }

    @Override
    @lombok.NonNull
    public String getRuleCategory() {
        return this.category;
    }

    @Override
    public boolean isRuleAvailable() {
        return this.availability.test(System.getProperties());
    }

    @Override
    @lombok.NonNull
    public RuleSeverity getRuleSeverity() {
        return this.severity;
    }

    @Override
    public @Nullable RuleIssue getRuleIssueOrNull(@lombok.NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return node instanceof Link ? this.validateLink((Link)node) : NO_RULE_ISSUE;
    }

    private @Nullable RuleIssue validateLink(@lombok.NonNull Link link) {
        ForgeRef found;
        if (link == null) {
            throw new NullPointerException("link is marked non-null but is null");
        }
        ForgeLink expected = (ForgeLink)Parser.of(this.linkParser).parse((CharSequence)link.getUrl());
        if (expected != null && this.linkPredicate.test(expected) && ForgeRefRuleSupport.isNotCompatibleRef(found = (ForgeRef)Parser.of(this.refParser).parse((CharSequence)link.getText()), expected)) {
            return RuleIssue.builder().message(this.message.apply(expected, found)).location((Node)link).build();
        }
        return NO_RULE_ISSUE;
    }

    private static <T extends ForgeLink> boolean isNotCompatibleRef(ForgeRef<T> found, T expected) {
        return found != null && !found.isCompatibleWith(expected);
    }

    @lombok.NonNull
    public static <L extends ForgeLink, R extends ForgeRef<L>> Builder<L, R> builder(Function<? super CharSequence, L> linkParser, Function<? super CharSequence, R> refParser) {
        return new Builder().linkParser(linkParser).refParser(refParser);
    }

    @Generated
    private static <L extends ForgeLink, R extends ForgeRef<L>> Predicate<Properties> $default$availability() {
        return properties -> true;
    }

    @Generated
    private static <L extends ForgeLink, R extends ForgeRef<L>> RuleSeverity $default$severity() {
        return RuleSeverity.ERROR;
    }

    @Generated
    private static <L extends ForgeLink, R extends ForgeRef<L>> Predicate<L> $default$linkPredicate() {
        return ignore -> true;
    }

    @Generated
    ForgeRefRuleSupport(@lombok.NonNull String id, @lombok.NonNull String name, @lombok.NonNull String category, @lombok.NonNull Predicate<Properties> availability, @lombok.NonNull RuleSeverity severity, @lombok.NonNull Function<? super CharSequence, L> linkParser, @lombok.NonNull Function<? super CharSequence, R> refParser, @lombok.NonNull Predicate<L> linkPredicate, @lombok.NonNull BiFunction<L, R, String> message) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (category == null) {
            throw new NullPointerException("category is marked non-null but is null");
        }
        if (availability == null) {
            throw new NullPointerException("availability is marked non-null but is null");
        }
        if (severity == null) {
            throw new NullPointerException("severity is marked non-null but is null");
        }
        if (linkParser == null) {
            throw new NullPointerException("linkParser is marked non-null but is null");
        }
        if (refParser == null) {
            throw new NullPointerException("refParser is marked non-null but is null");
        }
        if (linkPredicate == null) {
            throw new NullPointerException("linkPredicate is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.category = category;
        this.availability = availability;
        this.severity = severity;
        this.linkParser = linkParser;
        this.refParser = refParser;
        this.linkPredicate = linkPredicate;
        this.message = message;
    }

    @Generated
    public @NonNull Builder<L, R> toBuilder() {
        return new Builder().id(this.id).name(this.name).category(this.category).availability(this.availability).severity(this.severity).linkParser(this.linkParser).refParser(this.refParser).linkPredicate(this.linkPredicate).message(this.message);
    }

    @Generated
    public static class Builder<L extends ForgeLink, R extends ForgeRef<L>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String category;
        @Generated
        private boolean availability$set;
        @Generated
        private Predicate<Properties> availability$value;
        @Generated
        private boolean severity$set;
        @Generated
        private RuleSeverity severity$value;
        @Generated
        private Function<? super CharSequence, L> linkParser;
        @Generated
        private Function<? super CharSequence, R> refParser;
        @Generated
        private boolean linkPredicate$set;
        @Generated
        private Predicate<L> linkPredicate$value;
        @Generated
        private BiFunction<L, R, String> message;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder<L, R> id(@lombok.NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> name(@lombok.NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> category(@lombok.NonNull String category) {
            if (category == null) {
                throw new NullPointerException("category is marked non-null but is null");
            }
            this.category = category;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> availability(@lombok.NonNull Predicate<Properties> availability) {
            if (availability == null) {
                throw new NullPointerException("availability is marked non-null but is null");
            }
            this.availability$value = availability;
            this.availability$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> severity(@lombok.NonNull RuleSeverity severity) {
            if (severity == null) {
                throw new NullPointerException("severity is marked non-null but is null");
            }
            this.severity$value = severity;
            this.severity$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> linkParser(@lombok.NonNull Function<? super CharSequence, L> linkParser) {
            if (linkParser == null) {
                throw new NullPointerException("linkParser is marked non-null but is null");
            }
            this.linkParser = linkParser;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> refParser(@lombok.NonNull Function<? super CharSequence, R> refParser) {
            if (refParser == null) {
                throw new NullPointerException("refParser is marked non-null but is null");
            }
            this.refParser = refParser;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> linkPredicate(@lombok.NonNull Predicate<L> linkPredicate) {
            if (linkPredicate == null) {
                throw new NullPointerException("linkPredicate is marked non-null but is null");
            }
            this.linkPredicate$value = linkPredicate;
            this.linkPredicate$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder<L, R> message(@lombok.NonNull BiFunction<L, R, String> message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @Generated
        public @NonNull ForgeRefRuleSupport<L, R> build() {
            Predicate availability$value = this.availability$value;
            if (!this.availability$set) {
                availability$value = ForgeRefRuleSupport.$default$availability();
            }
            RuleSeverity severity$value = this.severity$value;
            if (!this.severity$set) {
                severity$value = ForgeRefRuleSupport.$default$severity();
            }
            Predicate linkPredicate$value = this.linkPredicate$value;
            if (!this.linkPredicate$set) {
                linkPredicate$value = ForgeRefRuleSupport.$default$linkPredicate();
            }
            return new ForgeRefRuleSupport<L, R>(this.id, this.name, this.category, availability$value, severity$value, this.linkParser, this.refParser, linkPredicate$value, this.message);
        }

        @Generated
        public @NonNull String toString() {
            return "ForgeRefRuleSupport.Builder(id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", availability$value=" + this.availability$value + ", severity$value=" + (Object)((Object)this.severity$value) + ", linkParser=" + this.linkParser + ", refParser=" + this.refParser + ", linkPredicate$value=" + this.linkPredicate$value + ", message=" + this.message + ")";
        }
    }
}

