/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nbbrd.heylogs.spi.Format;
import nbbrd.heylogs.spi.FormatBatch;

public final class FormatLoader {
    public static final Pattern ID_PATTERN = Pattern.compile("^[a-z0-9]+(?:-[a-z0-9]+)*$");
    private final Iterable<Format> source = ServiceLoader.load(Format.class);
    private final Iterable<FormatBatch> batch = ServiceLoader.load(FormatBatch.class);
    private final Predicate<Format> filter = o -> ID_PATTERN.matcher(o.getFormatId()).matches();
    private final List<Format> resource = this.doLoad();

    private List<Format> doLoad() {
        return Stream.concat(StreamSupport.stream(this.source.spliterator(), false), StreamSupport.stream(this.batch.spliterator(), false).flatMap(o -> o.getProviders())).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<Format> get() {
        return this.resource;
    }

    public static List<Format> load() {
        return new FormatLoader().get();
    }
}

