/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import com.vladsch.flexmark.util.ast.Node;
import java.util.Arrays;
import java.util.Properties;
import lombok.NonNull;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.heylogs.spi.RuleSeverity;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Rule {
    public static final RuleIssue NO_RULE_ISSUE = null;
    public static final String ENABLE_KEY = "heylogs.rule.enable";

    @NonNull
    public String getRuleId();

    @NonNull
    public String getRuleName();

    @NonNull
    public String getRuleCategory();

    public boolean isRuleAvailable();

    @NonNull
    public RuleSeverity getRuleSeverity();

    public @Nullable RuleIssue getRuleIssueOrNull(@NonNull Node var1);

    public static boolean isEnabled(@NonNull Properties properties, @NonNull String ruleId) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        if (ruleId == null) {
            throw new NullPointerException("ruleId is marked non-null but is null");
        }
        String list = properties.getProperty(ENABLE_KEY);
        return list != null && Arrays.asList(list.split(",", -1)).contains(ruleId);
    }
}

