/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleBatch;

public final class RuleLoader {
    public static final Pattern ID_PATTERN = Pattern.compile("^[a-z0-9]+(?:-[a-z0-9]+)*$");
    private final Iterable<Rule> source = ServiceLoader.load(Rule.class);
    private final Iterable<RuleBatch> batch = ServiceLoader.load(RuleBatch.class);
    private final Predicate<Rule> filter = ((Predicate<Rule>)o -> ID_PATTERN.matcher(o.getRuleId()).matches()).and(Rule::isRuleAvailable);
    private final List<Rule> resource = this.doLoad();

    private List<Rule> doLoad() {
        return Stream.concat(StreamSupport.stream(this.source.spliterator(), false), StreamSupport.stream(this.batch.spliterator(), false).flatMap(o -> o.getProviders())).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<Rule> get() {
        return this.resource;
    }

    public static List<Rule> load() {
        return new RuleLoader().get();
    }
}

