/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.spi;

import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import nbbrd.heylogs.spi.Versioning;

public final class VersioningLoader {
    public static final Pattern ID_PATTERN = Pattern.compile("^[a-z0-9]+(?:-[a-z0-9]+)*$");
    private final Iterable<Versioning> source = ServiceLoader.load(Versioning.class);
    private final Predicate<Versioning> filter = o -> ID_PATTERN.matcher(o.getVersioningId()).matches();
    private final List<Versioning> resource = this.doLoad();

    private List<Versioning> doLoad() {
        return StreamSupport.stream(this.source.spliterator(), false).filter(this.filter).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<Versioning> get() {
        return this.resource;
    }

    public static List<Versioning> load() {
        return new VersioningLoader().get();
    }
}

