/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.heylogs.ext.semver;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Properties;
import lombok.NonNull;
import nbbrd.heylogs.Version;
import nbbrd.heylogs.spi.Rule;
import nbbrd.heylogs.spi.RuleIssue;
import nbbrd.heylogs.spi.RuleSeverity;
import org.semver4j.Semver;

public final class SemVerRule
implements Rule {
    @NonNull
    public String getRuleId() {
        return "semver";
    }

    @NonNull
    public String getRuleName() {
        return "Semantic Versioning format";
    }

    @NonNull
    public String getRuleCategory() {
        return "versioning";
    }

    public RuleIssue getRuleIssueOrNull(@NonNull Node node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return node instanceof Heading ? this.validateSemVer((Heading)node) : NO_RULE_ISSUE;
    }

    public boolean isRuleAvailable() {
        return Rule.isEnabled((Properties)System.getProperties(), (String)this.getRuleId());
    }

    @NonNull
    public RuleSeverity getRuleSeverity() {
        return RuleSeverity.ERROR;
    }

    RuleIssue validateSemVer(Heading heading) {
        if (!Version.isVersionLevel((Heading)heading)) {
            return NO_RULE_ISSUE;
        }
        try {
            Version version = Version.parse((Heading)heading);
            if (version.isUnreleased()) {
                return NO_RULE_ISSUE;
            }
            String ref = version.getRef();
            return Semver.isValid((String)ref) ? NO_RULE_ISSUE : RuleIssue.builder().message("Invalid semver format: '" + ref + "'").location((Node)heading).build();
        }
        catch (IllegalArgumentException ex) {
            return NO_RULE_ISSUE;
        }
    }
}

