/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design.proc;

import internal.nbbrd.design.proc.Processors;
import internal.nbbrd.design.proc.Rule;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;
import nbbrd.design.SkipProcessing;

public final class Processing<T extends Element> {
    private final List<Rule<? super T>> checks;

    public static <X extends Element> Processing<X> of(Rule<X> ... rules) {
        return new Processing(Arrays.asList(rules));
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, ProcessingEnvironment env) {
        if (roundEnv.processingOver()) {
            return false;
        }
        Processors.streamOf(annotations, roundEnv).map(element -> element).filter(element -> !this.isSkipRequired((Element)element, env)).forEach(element -> this.checkAll(element, env));
        return true;
    }

    private void checkAll(T element, ProcessingEnvironment env) {
        this.checks.forEach(check -> {
            String result = check.check(env, element);
            if (result != null) {
                env.getMessager().printMessage(Diagnostic.Kind.ERROR, result, (Element)element);
            }
        });
    }

    private boolean isSkipRequired(Element element, ProcessingEnvironment env) {
        SkipProcessing skip = element.getAnnotation(SkipProcessing.class);
        if (skip != null) {
            env.getMessager().printMessage(Diagnostic.Kind.WARNING, "Processing skipped on '" + element + "'; reason: '" + skip.reason() + "'", element);
            return true;
        }
        return false;
    }

    @Generated
    private Processing(List<Rule<? super T>> checks) {
        this.checks = checks;
    }
}

