/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart;

import ec.util.chart.SeriesFunction;
import lombok.NonNull;

public abstract class SeriesPredicate {
    private static final SeriesPredicate TRUE = new SeriesPredicate(){

        @Override
        public boolean apply(int series) {
            return true;
        }
    };
    private static final SeriesPredicate FALSE = new SeriesPredicate(){

        @Override
        public boolean apply(int series) {
            return false;
        }
    };

    public abstract boolean apply(int var1);

    @NonNull
    public SeriesFunction<Boolean> asFunction() {
        return new AsFunction(this);
    }

    @NonNull
    public static SeriesPredicate alwaysTrue() {
        return TRUE;
    }

    @NonNull
    public static SeriesPredicate alwaysFalse() {
        return FALSE;
    }

    private static final class AsFunction
    extends SeriesFunction<Boolean> {
        private final SeriesPredicate predicate;

        public AsFunction(SeriesPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public Boolean apply(int series) {
            return this.predicate.apply(series);
        }
    }
}

