/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.ClusteredXYBarRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

class ClusteredXYBarRenderer2
extends ClusteredXYBarRenderer {
    private static final int SHADOW_PASS = 0;
    private static final int BAR_PASS = 1;
    private static final int LABEL_PASS = 2;
    protected final boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer2() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer2(double margin, boolean centerBarAtStartValue) {
        super(margin, centerBarAtStartValue);
        this.centerBarAtStartValue = centerBarAtStartValue;
    }

    public int getPassCount() {
        return 3;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Rectangle2D.Double bar;
        double m;
        double y1;
        double y0;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        if (pass == 0 && !this.getShadowsVisible()) {
            return;
        }
        if (pass == 2 && !this.isItemLabelVisible(series, item)) {
            return;
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        if (this.getUseYInterval()) {
            y0 = intervalDataset.getStartYValue(series, item);
            y1 = intervalDataset.getEndYValue(series, item);
        } else {
            y0 = this.getBase();
            y1 = intervalDataset.getYValue(series, item);
        }
        if (Double.isNaN(y0) || Double.isNaN(y1)) {
            return;
        }
        double yy0 = rangeAxis.valueToJava2D(y0, dataArea, plot.getRangeAxisEdge());
        double yy1 = rangeAxis.valueToJava2D(y1, dataArea, plot.getRangeAxisEdge());
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        double x0 = intervalDataset.getStartXValue(series, item);
        double xx0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
        double x1 = intervalDataset.getEndXValue(series, item);
        double xx1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double intervalW = xx1 - xx0;
        double baseX = xx0;
        if (this.centerBarAtStartValue) {
            baseX -= intervalW / 2.0;
        }
        if ((m = this.getMargin()) > 0.0) {
            double cut = intervalW * this.getMargin();
            intervalW -= cut;
            baseX += cut / 2.0;
        }
        double intervalH = Math.abs(yy0 - yy1);
        PlotOrientation orientation = plot.getOrientation();
        int numSeries = dataset.getSeriesCount();
        double seriesBarWidth = intervalW / (double)numSeries;
        if (orientation == PlotOrientation.HORIZONTAL) {
            double barY0 = baseX + seriesBarWidth * (double)series;
            double barY1 = barY0 + seriesBarWidth;
            double rx = Math.min(yy0, yy1);
            double rw = intervalH;
            double ry = Math.min(barY0, barY1);
            double rh = Math.abs(barY1 - barY0);
            bar = new Rectangle2D.Double(rx, ry, rw, rh);
        } else {
            double barX0 = baseX + seriesBarWidth * (double)series;
            double barX1 = barX0 + seriesBarWidth;
            double rx = Math.min(barX0, barX1);
            double rw = Math.abs(barX1 - barX0);
            double ry = Math.min(yy0, yy1);
            double rh = intervalH;
            bar = new Rectangle2D.Double(rx, ry, rw, rh);
        }
        boolean positive = y1 > 0.0;
        boolean inverted = rangeAxis.isInverted();
        RectangleEdge barBase = orientation == PlotOrientation.HORIZONTAL ? (positive && inverted || !positive && !inverted ? RectangleEdge.RIGHT : RectangleEdge.LEFT) : (positive && !inverted || !positive && inverted ? RectangleEdge.BOTTOM : RectangleEdge.TOP);
        switch (pass) {
            case 0: {
                this.getBarPainter().paintBarShadow(g2, (XYBarRenderer)this, series, item, (RectangularShape)bar, barBase, !this.getUseYInterval());
                break;
            }
            case 1: {
                EntityCollection entities;
                this.getBarPainter().paintBar(g2, (XYBarRenderer)this, series, item, (RectangularShape)bar, barBase);
                if (info == null || (entities = info.getOwner().getEntityCollection()) == null) break;
                this.addEntity(entities, bar, dataset, series, item, bar.getCenterX(), bar.getCenterY());
                break;
            }
            case 2: {
                XYItemLabelGenerator generator = this.getItemLabelGenerator(series, item);
                this.drawItemLabel(g2, dataset, series, item, plot, generator, bar, y1 < 0.0);
            }
        }
    }
}

