/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.ColorScheme;
import ec.util.chart.swing.SwingColorSchemeSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.Icon;
import lombok.NonNull;

public final class ColorSchemeIcon
implements Icon {
    private static final Dimension DEFAULT_SIZE = new Dimension(17, 16);
    private static final int DEFAULT_BORDER_THICKNESS = 1;
    private static final int DEFAULT_COLOR_COUNT = 3;
    private final Dimension size;
    private final int borderThickness;
    private final SwingColorSchemeSupport support;
    private final int colorCount;
    private final int colorWidth;
    private final int colorHeight;

    public ColorSchemeIcon(@NonNull ColorScheme colorScheme) {
        this(DEFAULT_SIZE, 1, SwingColorSchemeSupport.from(colorScheme), 3);
        if (colorScheme == null) {
            throw new NullPointerException("colorScheme is marked non-null but is null");
        }
    }

    private ColorSchemeIcon(@NonNull Dimension size, int borderThickness, @NonNull SwingColorSchemeSupport support, int colorCount) {
        if (support == null) {
            throw new NullPointerException("support is marked non-null but is null");
        }
        this.size = Objects.requireNonNull(size, "size");
        if (borderThickness < 0) {
            throw new IllegalArgumentException("Border thickness must be >= 0");
        }
        this.borderThickness = borderThickness;
        this.support = Objects.requireNonNull(support, "colorSchemeSupport");
        if (colorCount <= 0) {
            throw new IllegalArgumentException("Color count must be > 0");
        }
        this.colorCount = colorCount;
        this.colorWidth = (size.width - borderThickness * 2) / colorCount;
        this.colorHeight = size.height - borderThickness * 2;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color savedColor = g.getColor();
        g.setColor((Color)this.support.getPlotColor());
        g.fillRect(x, y, this.size.width, this.size.height);
        for (int i = 0; i < this.colorCount; ++i) {
            g.setColor((Color)this.support.getLineColor(i));
            g.fillRect(x + this.borderThickness + this.colorWidth * i, y + this.borderThickness, this.colorWidth, this.colorHeight);
        }
        g.setColor(savedColor);
    }

    @Override
    public int getIconWidth() {
        return this.size.width;
    }

    @Override
    public int getIconHeight() {
        return this.size.height;
    }
}

