/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.Charts;
import ec.util.chart.swing.ClusteredXYBarRenderer2;
import ec.util.chart.swing.HighlightedXYItemRenderer;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PaintList;
import org.jfree.util.StrokeList;

public class HighlightedClusteredXYBarRenderer
extends ClusteredXYBarRenderer2
implements HighlightedXYItemRenderer {
    final Point highlight = new Point(-1, -1);
    final PaintList itemLabelBackgroundPaintList = new PaintList();
    final PaintList itemLabelOutlinePaintList = new PaintList();
    final StrokeList itemLabelOutlineStrokeList = new StrokeList();

    @Override
    public void setHighlightedItem(int series, int item) {
        if (this.highlight.x != series || this.highlight.y != item) {
            this.highlight.setLocation(series, item);
            this.notifyListeners(new RendererChangeEvent((Object)this));
        }
    }

    protected boolean isHighlightedItem(int series, int item) {
        return this.highlight.x == series && this.highlight.y == item;
    }

    public boolean isItemLabelVisible(int series, int item) {
        return this.isHighlightedItem(series, item);
    }

    @Override
    public Paint getSeriesItemLabelBackgroundPaint(int series) {
        return this.itemLabelBackgroundPaintList.getPaint(series);
    }

    @Override
    public void setSeriesItemLabelBackgroundPaint(int series, Paint paint) {
        this.itemLabelBackgroundPaintList.setPaint(series, paint);
        this.notifyListeners(new RendererChangeEvent((Object)this));
    }

    @Override
    public Paint getSeriesItemLabelOutlinePaint(int series) {
        return this.itemLabelOutlinePaintList.getPaint(series);
    }

    @Override
    public void setSeriesItemLabelOutlinePaint(int series, Paint paint) {
        this.itemLabelOutlinePaintList.setPaint(series, paint);
        this.notifyListeners(new RendererChangeEvent((Object)this));
    }

    @Override
    public Stroke getSeriesItemLabelOutlineStroke(int series) {
        return this.itemLabelOutlineStrokeList.getStroke(series);
    }

    @Override
    public void setSeriesItemLabelOutlineStroke(int series, Stroke paint) {
        this.itemLabelOutlineStrokeList.setStroke(series, paint);
        this.notifyListeners(new RendererChangeEvent((Object)this));
    }

    @Deprecated
    public Paint getItemLabelBackgroundPaint(int series, int item) {
        return this.getSeriesItemLabelBackgroundPaint(series);
    }

    public Paint getItemLabelFillPaint(int series, int item) {
        return this.getItemLabelBackgroundPaint(series, item);
    }

    public Paint getItemLabelOutlinePaint(int series, int item) {
        return this.getSeriesItemLabelOutlinePaint(series);
    }

    public Stroke getItemLabelOutlineStroke(int series, int item) {
        return this.getSeriesItemLabelOutlineStroke(series);
    }

    protected void drawItemLabel(Graphics2D g2, XYDataset dataset, int series, int item, XYPlot plot, XYItemLabelGenerator generator, Rectangle2D bar, boolean negative) {
        if (generator == null) {
            return;
        }
        String label = generator.generateLabel(dataset, series, item);
        if (label == null || label.isEmpty()) {
            return;
        }
        this.drawItemLabel(g2, bar.getCenterX(), bar.getCenterY(), negative, plot.getOrientation(), series, item, label);
    }

    protected void drawItemLabel(Graphics2D g2, double x, double y, boolean negative, PlotOrientation orientation, int series, int item, String label) {
        Paint paint;
        label = " " + label + " ";
        ItemLabelPosition position = Charts.computeItemLabelPosition(g2.getClipBounds(), x, y);
        Point2D anchorPoint = this.calculateLabelAnchorPoint(position.getItemLabelAnchor(), x, y, orientation);
        g2.setFont(this.getItemLabelFont(series, item));
        Shape hotspot = TextUtilities.calculateRotatedStringBounds((String)label, (Graphics2D)g2, (float)((float)anchorPoint.getX()), (float)((float)anchorPoint.getY()), (TextAnchor)position.getTextAnchor(), (double)position.getAngle(), (TextAnchor)position.getRotationAnchor());
        Paint fillPaint = this.getItemLabelFillPaint(series, item);
        if (fillPaint != null) {
            g2.setPaint(fillPaint);
            g2.fill(hotspot);
        }
        if ((paint = this.getItemLabelPaint(series, item)) != null) {
            g2.setPaint(paint);
            TextUtilities.drawRotatedString((String)label, (Graphics2D)g2, (float)((float)anchorPoint.getX()), (float)((float)anchorPoint.getY()), (TextAnchor)position.getTextAnchor(), (double)position.getAngle(), (TextAnchor)position.getRotationAnchor());
        }
        Paint outlinePaint = this.getItemLabelOutlinePaint(series, item);
        Stroke outlineStroke = this.getItemLabelOutlineStroke(series, item);
        if (outlinePaint != null && outlineStroke != null) {
            g2.setStroke(outlineStroke);
            g2.setPaint(outlinePaint);
            g2.draw(hotspot);
        }
    }
}

