/*
 * Decompiled with CFR 0.152.
 */
package ec.util.chart.swing;

import ec.util.chart.swing.HighlightedXYItemRenderer2;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class HighlightChartMouseListener
implements ChartMouseListener {
    public void chartMouseClicked(ChartMouseEvent event) {
    }

    public void chartMouseMoved(ChartMouseEvent event) {
        if (event.getChart().getPlot() instanceof XYPlot) {
            this.handle(event.getChart().getXYPlot(), event.getEntity());
        }
    }

    private void handle(XYPlot plot, ChartEntity entity) {
        if (entity instanceof XYItemEntity) {
            this.highlight(plot, (XYItemEntity)entity);
        } else {
            this.reset(plot);
        }
    }

    private void highlight(XYPlot plot, XYItemEntity entity) {
        if (plot instanceof CombinedDomainXYPlot) {
            ((CombinedDomainXYPlot)plot).getSubplots().forEach(o -> this.highlight((XYPlot)o, entity));
        } else {
            XYItemRenderer r = plot.getRendererForDataset(entity.getDataset());
            if (r instanceof HighlightedXYItemRenderer2) {
                ((HighlightedXYItemRenderer2)r).setHighlightedItem(entity.getSeriesIndex(), entity.getItem());
            }
        }
    }

    private void reset(XYPlot plot) {
        if (plot instanceof CombinedDomainXYPlot) {
            ((CombinedDomainXYPlot)plot).getSubplots().forEach(o -> this.reset((XYPlot)o));
        } else {
            for (int i = 0; i < plot.getRendererCount(); ++i) {
                XYItemRenderer r = plot.getRenderer(i);
                if (!(r instanceof HighlightedXYItemRenderer2)) continue;
                ((HighlightedXYItemRenderer2)r).setHighlightedItem(-1, -1);
            }
        }
    }
}

