/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import ec.util.desktop.impl.Trash;
import ec.util.desktop.impl.Util;
import java.awt.Desktop;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import lombok.NonNull;

public class AwtDesktop
implements Desktop {
    private final java.awt.Desktop awt = java.awt.Desktop.getDesktop();
    private final Trash trash = Trash.getDefault();

    @Override
    public boolean isSupported(@NonNull Desktop.Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        switch (action) {
            case BROWSE: {
                return this.awt.isSupported(Desktop.Action.BROWSE);
            }
            case EDIT: {
                return this.awt.isSupported(Desktop.Action.EDIT);
            }
            case MAIL: {
                return this.awt.isSupported(Desktop.Action.MAIL);
            }
            case OPEN: {
                return this.awt.isSupported(Desktop.Action.OPEN);
            }
            case PRINT: {
                return this.awt.isSupported(Desktop.Action.PRINT);
            }
            case SHOW_IN_FOLDER: {
                return this.awt.isSupported(Desktop.Action.OPEN);
            }
            case MOVE_TO_TRASH: {
                return this.trash.hasTrash();
            }
            case SEARCH: {
                return false;
            }
            case KNOWN_FOLDER_LOOKUP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void open(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.awt.open(file);
    }

    @Override
    public void edit(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.awt.edit(file);
    }

    @Override
    public void print(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.awt.print(file);
    }

    @Override
    public void browse(@NonNull URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.awt.browse(uri);
    }

    @Override
    public void mail() throws IOException {
        this.awt.mail();
    }

    @Override
    public void mail(@NonNull URI mailtoURI) throws IOException {
        if (mailtoURI == null) {
            throw new NullPointerException("mailtoURI is marked non-null but is null");
        }
        this.awt.mail(mailtoURI);
    }

    @Override
    public void showInFolder(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.awt.open(file.isDirectory() ? file : file.getParentFile());
    }

    @Override
    public void moveToTrash(File ... files) throws IOException {
        if (files == null) {
            throw new NullPointerException("files is marked non-null but is null");
        }
        this.trash.moveToTrash(files);
    }

    @Override
    public File getKnownFolderPath(@NonNull Desktop.KnownFolder knownFolder) throws IOException {
        if (knownFolder == null) {
            throw new NullPointerException("knownFolder is marked non-null but is null");
        }
        return this.getKnownFolder(knownFolder);
    }

    @Override
    public File getKnownFolder(@NonNull Desktop.KnownFolder userDir) {
        if (userDir == null) {
            throw new NullPointerException("userDir is marked non-null but is null");
        }
        return null;
    }

    @Override
    public File[] search(@NonNull String query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Deprecated
    @NonNull
    protected static File checkFile(File file) throws NullPointerException, IllegalArgumentException {
        return Util.checkFileValidation(file);
    }

    @Deprecated
    protected static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    @NonNull
    protected static File extractResource(@NonNull String resourceName, @NonNull String filePrefix, @NonNull String fileSuffix) throws IOException {
        if (resourceName == null) {
            throw new NullPointerException("resourceName is marked non-null but is null");
        }
        if (filePrefix == null) {
            throw new NullPointerException("filePrefix is marked non-null but is null");
        }
        if (fileSuffix == null) {
            throw new NullPointerException("fileSuffix is marked non-null but is null");
        }
        return Util.extractResource(resourceName, filePrefix, fileSuffix);
    }

    @Deprecated
    @NonNull
    protected static File[] toFiles(@NonNull Process p, @NonNull Charset charset) throws IOException {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        return Util.toFiles(p, charset);
    }

    public static class Factory
    implements Desktop.Factory {
        @Override
        public @NonNull Desktop.Factory.SupportType getSupportType(String osArch, String osName, String osVersion) {
            return Desktop.Factory.SupportType.BASIC;
        }

        @Override
        @NonNull
        public Desktop create(String osArch, String osName, String osVersion) {
            return new AwtDesktop();
        }
    }
}

