/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;

final class Processes {
    private Processes() {
    }

    @NonNull
    public static Process noOp() {
        return NoOpProcess.INSTANCE;
    }

    private static final class NoOpProcess
    extends Process {
        public static final NoOpProcess INSTANCE = new NoOpProcess();

        private NoOpProcess() {
        }

        @Override
        public OutputStream getOutputStream() {
            return NullOutputStream.INSTANCE;
        }

        @Override
        public InputStream getInputStream() {
            return NullInputStream.INSTANCE;
        }

        @Override
        public InputStream getErrorStream() {
            return NullInputStream.INSTANCE;
        }

        @Override
        public int waitFor() throws InterruptedException {
            return 0;
        }

        @Override
        public int exitValue() {
            return 0;
        }

        @Override
        public void destroy() {
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        static final NullOutputStream INSTANCE = new NullOutputStream();

        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Stream closed");
        }
    }

    private static final class NullInputStream
    extends InputStream {
        static final NullInputStream INSTANCE = new NullInputStream();

        private NullInputStream() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int available() {
            return 0;
        }
    }
}

