/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;

abstract class Trash {
    @Generated
    private static final Logger log = Logger.getLogger(Trash.class.getName());

    Trash() {
    }

    public abstract boolean hasTrash();

    public abstract void moveToTrash(File ... var1) throws IOException;

    @NonNull
    public static Trash getDefault() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        private static final Trash INSTANCE = LazyHolder.createInstance();

        private LazyHolder() {
        }

        private static Trash createInstance() {
            log.log(Level.INFO, "Using NoOpTrash");
            return new NoOpTrash();
        }
    }

    private static final class NoOpTrash
    extends Trash {
        private NoOpTrash() {
        }

        @Override
        public boolean hasTrash() {
            return false;
        }

        @Override
        public void moveToTrash(File ... files) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

