/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.Desktop;
import ec.util.desktop.impl.AwtDesktop;
import ec.util.desktop.impl.Util;
import ec.util.desktop.impl.WinRegistry;
import ec.util.desktop.impl.WinSearch;
import ec.util.desktop.impl.ZSystem;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WinDesktop
extends AwtDesktop {
    private static final Logger LOGGER = Logger.getLogger(WinDesktop.class.getName());
    static final String SHELL_FOLDERS_KEY_PATH = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
    static final String DESKTOP_SEARCH_KEY_PATH = "Software\\Microsoft\\Windows Desktop Search";
    static final String DESKTOP_DIR = "Desktop";
    static final String DOCUMENTS_DIR = "Personal";
    static final String DOWNLOAD_DIR = "{374DE290-123F-4565-9164-39C4925E467B}";
    static final String MUSIC_DIR = "My Music";
    static final String PICTURES_DIR = "My Pictures";
    static final String PUBLICSHARE_DIR = "{ED4824AF-DCE4-45A8-81E2-FC7965083634}";
    static final String TEMPLATES_DIR = "Templates";
    static final String VIDEOS_DIR = "My Video";
    static final String QUOTE = "\"";
    @NonNull
    private final WinRegistry registry;
    @NonNull
    private final ZSystem system;
    @NonNull
    private final WinSearch search;

    WinDesktop(@NonNull WinRegistry registry, @NonNull ZSystem launcher, @NonNull WinSearch search) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        if (launcher == null) {
            throw new NullPointerException("launcher is marked non-null but is null");
        }
        if (search == null) {
            throw new NullPointerException("search is marked non-null but is null");
        }
        this.registry = registry;
        this.search = search;
        this.system = launcher;
    }

    @Override
    public boolean isSupported(@NonNull Desktop.Action action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        switch (action) {
            case SHOW_IN_FOLDER: {
                return true;
            }
            case SEARCH: {
                return WinDesktop.isSearchEngineInstalled(this.registry);
            }
        }
        return super.isSupported(action);
    }

    @Override
    public void showInFolder(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Util.checkFileValidation(file);
        WinDesktop.showInFolder(this.system, file);
    }

    @Override
    public File getKnownFolderPath(@NonNull Desktop.KnownFolder knownFolder) throws IOException {
        if (knownFolder == null) {
            throw new NullPointerException("knownFolder is marked non-null but is null");
        }
        switch (knownFolder) {
            case DESKTOP: {
                return WinDesktop.getKnownFolderByName(this.registry, DESKTOP_DIR);
            }
            case DOCUMENTS: {
                return WinDesktop.getKnownFolderByName(this.registry, DOCUMENTS_DIR);
            }
            case DOWNLOAD: {
                return WinDesktop.getKnownFolderByName(this.registry, DOWNLOAD_DIR);
            }
            case MUSIC: {
                return WinDesktop.getKnownFolderByName(this.registry, MUSIC_DIR);
            }
            case PICTURES: {
                return WinDesktop.getKnownFolderByName(this.registry, PICTURES_DIR);
            }
            case PUBLICSHARE: {
                return WinDesktop.getKnownFolderByName(this.registry, PUBLICSHARE_DIR);
            }
            case TEMPLATES: {
                return WinDesktop.getKnownFolderByName(this.registry, TEMPLATES_DIR);
            }
            case VIDEOS: {
                return WinDesktop.getKnownFolderByName(this.registry, VIDEOS_DIR);
            }
        }
        return null;
    }

    @Override
    public File getKnownFolder(@NonNull Desktop.KnownFolder knownFolder) {
        if (knownFolder == null) {
            throw new NullPointerException("knownFolder is marked non-null but is null");
        }
        try {
            return this.getKnownFolderPath(knownFolder);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "While getting known folder", ex);
            return null;
        }
    }

    @Override
    public File[] search(@NonNull String query) throws IOException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (!this.isSupported(Desktop.Action.SEARCH)) {
            throw new UnsupportedOperationException(Desktop.Action.SEARCH.name());
        }
        return this.search.search(query);
    }

    private static void showInFolder(@NonNull ZSystem system, @NonNull File file) throws IOException {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        system.exec("explorer.exe", "/select,", WinDesktop.quote(file.getAbsolutePath()));
    }

    private static boolean isSearchEngineInstalled(@NonNull WinRegistry registry) {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        try {
            return registry.keyExists(WinRegistry.Root.HKEY_LOCAL_MACHINE, DESKTOP_SEARCH_KEY_PATH);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "While checking desktop search existence", ex);
            return false;
        }
    }

    private static @Nullable File getKnownFolderByName(@NonNull WinRegistry registry, @NonNull String winFolderName) throws IOException {
        if (registry == null) {
            throw new NullPointerException("registry is marked non-null but is null");
        }
        if (winFolderName == null) {
            throw new NullPointerException("winFolderName is marked non-null but is null");
        }
        Object result = registry.getValue(WinRegistry.Root.HKEY_CURRENT_USER, SHELL_FOLDERS_KEY_PATH, winFolderName);
        return result instanceof String && !((String)result).isEmpty() ? new File((String)result) : null;
    }

    @NonNull
    private static String quote(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return QUOTE + input + QUOTE;
    }

    public static class Factory
    implements Desktop.Factory {
        @Override
        @NonNull
        public Desktop.Factory.SupportType getSupportType(String osArch, String osName, String osVersion) {
            return osName.startsWith("Windows ") ? Desktop.Factory.SupportType.GENERIC : Desktop.Factory.SupportType.NONE;
        }

        @Override
        @NonNull
        public Desktop create(String osArch, String osName, String osVersion) {
            WinRegistry registry = WinRegistry.getDefault();
            ZSystem launcher = ZSystem.getDefault();
            WinSearch search = WinSearch.getDefault();
            return new WinDesktop(registry, launcher, search);
        }
    }
}

