/*
 * Decompiled with CFR 0.152.
 */
package ec.util.desktop.impl;

import ec.util.desktop.impl.ZSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class XdgConfig {
    XdgConfig() {
    }

    public abstract @Nullable String get(@NonNull String var1);

    @NonNull
    public abstract Set<String> keySet();

    @NonNull
    public static XdgConfig getInstance(ZSystem system) throws IOException {
        File configFile = XdgConfig.getConfigFile(system);
        if (configFile != null) {
            try (InputStream stream = Files.newInputStream(configFile.toPath(), new OpenOption[0]);){
                XdgConfig xdgConfig = XdgConfig.parseConfig(stream, system.getEnv());
                return xdgConfig;
            }
        }
        throw new IOException("Config file not found");
    }

    @NonNull
    public static XdgConfig noOp() {
        return NoOpConfig.INSTANCE;
    }

    private static @Nullable File getConfigFile(@NonNull ZSystem system) {
        if (system == null) {
            throw new NullPointerException("system is marked non-null but is null");
        }
        File result = XdgConfig.newFile(system.getEnv("XDG_CONFIG_HOME"), "user-dirs.dirs");
        if (XdgConfig.isFile(result)) {
            return result;
        }
        result = XdgConfig.newFile(system.getProperty("user.home"), ".config", "user-dirs.dirs");
        if (XdgConfig.isFile(result)) {
            return result;
        }
        return null;
    }

    @NonNull
    static XdgConfig parseConfig(@NonNull InputStream stream, @NonNull Map<String, String> env) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> tmp = new HashMap<String, String>();
        try (Scanner s = new Scanner(stream, "UTF-8");){
            while (s.hasNextLine()) {
                int idx;
                String line = s.nextLine();
                if (line.startsWith("#") || (idx = line.indexOf(61)) == -1) continue;
                tmp.put(line.substring(0, idx), line.substring(idx));
            }
        }
        for (Map.Entry entry : tmp.entrySet()) {
            String value = ((String)entry.getValue()).replace("\"", "");
            for (Map.Entry<String, String> o : env.entrySet()) {
                int idx = value.indexOf(o.getKey());
                if (idx == -1) continue;
                value = o.getValue() + value.substring(idx + o.getKey().length());
            }
            result.put((String)entry.getKey(), value);
        }
        return new MapConfig(result);
    }

    private static @Nullable File newFile(@Nullable String parent, String ... children) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (parent == null || parent.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder(parent);
        for (String o : children) {
            result.append(File.separatorChar).append(o);
        }
        return new File(result.toString());
    }

    private static boolean isFile(@Nullable File file) {
        return file != null && file.isFile();
    }

    private static final class NoOpConfig
    extends XdgConfig {
        public static final NoOpConfig INSTANCE = new NoOpConfig();

        private NoOpConfig() {
        }

        @Override
        public String get(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return null;
        }

        @Override
        @NonNull
        public Set<String> keySet() {
            return Collections.emptySet();
        }
    }

    private static final class MapConfig
    extends XdgConfig {
        private final Map<String, String> map;

        public MapConfig(Map<String, String> map) {
            this.map = map;
        }

        @Override
        public String get(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            return this.map.get(name);
        }

        @Override
        @NonNull
        public Set<String> keySet() {
            return this.map.keySet();
        }
    }
}

