/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import internal.io.text.BufferedInputStreamWithFile;
import internal.io.text.FileSystemExceptions;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;

public final class LegacyFiles {
    public static Reader openReader(CharSequence source) {
        return new StringReader(source.toString());
    }

    public static Reader openReader(IOSupplier<? extends Reader> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing Reader");
    }

    public static InputStream openInputStream(IOSupplier<? extends InputStream> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing InputStream");
    }

    @NonNull
    public static InputStream openInputStream(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return new BufferedInputStreamWithFile(FileSystemExceptions.checkSource(source));
    }

    public static Writer openWriter(IOSupplier<? extends Writer> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing Writer");
    }

    public static OutputStream openOutputStream(IOSupplier<? extends OutputStream> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing OutputStream");
    }

    @NonNull
    public static OutputStream openOutputStream(@NonNull File target) throws IOException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return new BufferedOutputStream(new FileOutputStream(FileSystemExceptions.checkTarget(target)));
    }

    public static String toSystemId(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return file.toURI().toASCIIString();
    }

    public static File fromSystemId(@NonNull String systemId) {
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        if (systemId.startsWith("file:/")) {
            try {
                return new File(new URI(systemId));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <T extends Closeable> T checkResource(T resource, String message) throws IOException {
        if (resource == null) {
            throw new IOException(message);
        }
        return resource;
    }

    @Generated
    private LegacyFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

