/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

public class BlockSizer {
    public static final AtomicReference<BlockSizer> INSTANCE = new AtomicReference<BlockSizer>(new BlockSizer());
    public static final long DEFAULT_BLOCK_BUFFER_SIZE = 512L;
    public static final long DEFAULT_BUFFER_OUTPUT_STREAM_SIZE = 8192L;
    public static final long UNKNOWN_SIZE = -1L;

    public long getBlockSize(@NonNull Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return 512L;
    }

    public long getBlockSize(@NonNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return stream.available();
    }

    public long getBlockSize(@NonNull OutputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        return stream instanceof BufferedOutputStream ? 8192L : -1L;
    }
}

