/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import lombok.NonNull;

@FunctionalInterface
public interface IOConsumer<T> {
    public void acceptWithIO(T var1) throws IOException;

    @NonNull
    default public IOConsumer<T> andThen(@NonNull IOConsumer<? super T> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return t -> {
            this.acceptWithIO(t);
            after.acceptWithIO(t);
        };
    }

    @NonNull
    default public Consumer<T> asUnchecked() {
        return t -> {
            try {
                this.acceptWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    @NonNull
    public static <T> Consumer<T> unchecked(@NonNull IOConsumer<T> o) {
        if (o == null) {
            throw new NullPointerException("o is marked non-null but is null");
        }
        return o.asUnchecked();
    }

    @NonNull
    public static <T> IOConsumer<T> checked(@NonNull Consumer<T> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return o -> {
            try {
                consumer.accept(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    @NonNull
    public static <T> IOConsumer<T> noOp() {
        return o -> {};
    }
}

