/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.http;

import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import lombok.Generated;
import nbbrd.io.http.HttpAuthenticator;
import nbbrd.io.http.HttpEventListener;
import nbbrd.io.http.StreamDecoder;
import nbbrd.io.http.URLConnectionFactory;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class HttpContext {
    private static final int NO_TIMEOUT = 0;
    private final @NonNegative int readTimeout;
    private final @NonNegative int connectTimeout;
    private final @NonNegative int maxRedirects;
    @lombok.NonNull
    private final Supplier<ProxySelector> proxySelector;
    @lombok.NonNull
    private final Supplier<SSLSocketFactory> sslSocketFactory;
    @lombok.NonNull
    private final Supplier<HostnameVerifier> hostnameVerifier;
    @lombok.NonNull
    private final Supplier<URLConnectionFactory> urlConnectionFactory;
    @lombok.NonNull
    private final HttpEventListener listener;
    private final List<StreamDecoder> decoders;
    @lombok.NonNull
    private final HttpAuthenticator authenticator;
    private final boolean preemptiveAuthentication;
    private final String userAgent;

    public static Builder builder() {
        return new Builder().decoder(StreamDecoder.gzip()).decoder(StreamDecoder.deflate());
    }

    @Generated
    private static int $default$readTimeout() {
        return 0;
    }

    @Generated
    private static int $default$connectTimeout() {
        return 0;
    }

    @Generated
    private static int $default$maxRedirects() {
        return 20;
    }

    @Generated
    private static Supplier<ProxySelector> $default$proxySelector() {
        return ProxySelector::getDefault;
    }

    @Generated
    private static Supplier<SSLSocketFactory> $default$sslSocketFactory() {
        return HttpsURLConnection::getDefaultSSLSocketFactory;
    }

    @Generated
    private static Supplier<HostnameVerifier> $default$hostnameVerifier() {
        return HttpsURLConnection::getDefaultHostnameVerifier;
    }

    @Generated
    private static Supplier<URLConnectionFactory> $default$urlConnectionFactory() {
        return URLConnectionFactory::getDefault;
    }

    @Generated
    private static HttpEventListener $default$listener() {
        return HttpEventListener.noOp();
    }

    @Generated
    private static HttpAuthenticator $default$authenticator() {
        return HttpAuthenticator.noOp();
    }

    @Generated
    private static boolean $default$preemptiveAuthentication() {
        return false;
    }

    @Generated
    private static String $default$userAgent() {
        return null;
    }

    @Generated
    HttpContext(@NonNegative int readTimeout, @NonNegative int connectTimeout, @NonNegative int maxRedirects, @lombok.NonNull Supplier<ProxySelector> proxySelector, @lombok.NonNull Supplier<SSLSocketFactory> sslSocketFactory, @lombok.NonNull Supplier<HostnameVerifier> hostnameVerifier, @lombok.NonNull Supplier<URLConnectionFactory> urlConnectionFactory, @lombok.NonNull HttpEventListener listener, List<StreamDecoder> decoders, @lombok.NonNull HttpAuthenticator authenticator, boolean preemptiveAuthentication, String userAgent) {
        if (proxySelector == null) {
            throw new NullPointerException("proxySelector is marked non-null but is null");
        }
        if (sslSocketFactory == null) {
            throw new NullPointerException("sslSocketFactory is marked non-null but is null");
        }
        if (hostnameVerifier == null) {
            throw new NullPointerException("hostnameVerifier is marked non-null but is null");
        }
        if (urlConnectionFactory == null) {
            throw new NullPointerException("urlConnectionFactory is marked non-null but is null");
        }
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        if (authenticator == null) {
            throw new NullPointerException("authenticator is marked non-null but is null");
        }
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.maxRedirects = maxRedirects;
        this.proxySelector = proxySelector;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.urlConnectionFactory = urlConnectionFactory;
        this.listener = listener;
        this.decoders = decoders;
        this.authenticator = authenticator;
        this.preemptiveAuthentication = preemptiveAuthentication;
        this.userAgent = userAgent;
    }

    @Generated
    public @NonNull Builder toBuilder() {
        Builder builder = new Builder().readTimeout(this.readTimeout).connectTimeout(this.connectTimeout).maxRedirects(this.maxRedirects).proxySelector(this.proxySelector).sslSocketFactory(this.sslSocketFactory).hostnameVerifier(this.hostnameVerifier).urlConnectionFactory(this.urlConnectionFactory).listener(this.listener).authenticator(this.authenticator).preemptiveAuthentication(this.preemptiveAuthentication).userAgent(this.userAgent);
        if (this.decoders != null) {
            builder.decoders(this.decoders);
        }
        return builder;
    }

    @Generated
    public @NonNegative int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public @NonNegative int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public @NonNegative int getMaxRedirects() {
        return this.maxRedirects;
    }

    @lombok.NonNull
    @Generated
    public Supplier<ProxySelector> getProxySelector() {
        return this.proxySelector;
    }

    @lombok.NonNull
    @Generated
    public Supplier<SSLSocketFactory> getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @lombok.NonNull
    @Generated
    public Supplier<HostnameVerifier> getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @lombok.NonNull
    @Generated
    public Supplier<URLConnectionFactory> getUrlConnectionFactory() {
        return this.urlConnectionFactory;
    }

    @lombok.NonNull
    @Generated
    public HttpEventListener getListener() {
        return this.listener;
    }

    @Generated
    public List<StreamDecoder> getDecoders() {
        return this.decoders;
    }

    @lombok.NonNull
    @Generated
    public HttpAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    @Generated
    public boolean isPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpContext)) {
            return false;
        }
        HttpContext other = (HttpContext)o;
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getMaxRedirects() != other.getMaxRedirects()) {
            return false;
        }
        if (this.isPreemptiveAuthentication() != other.isPreemptiveAuthentication()) {
            return false;
        }
        Supplier<ProxySelector> this$proxySelector = this.getProxySelector();
        Supplier<ProxySelector> other$proxySelector = other.getProxySelector();
        if (this$proxySelector == null ? other$proxySelector != null : !this$proxySelector.equals(other$proxySelector)) {
            return false;
        }
        Supplier<SSLSocketFactory> this$sslSocketFactory = this.getSslSocketFactory();
        Supplier<SSLSocketFactory> other$sslSocketFactory = other.getSslSocketFactory();
        if (this$sslSocketFactory == null ? other$sslSocketFactory != null : !this$sslSocketFactory.equals(other$sslSocketFactory)) {
            return false;
        }
        Supplier<HostnameVerifier> this$hostnameVerifier = this.getHostnameVerifier();
        Supplier<HostnameVerifier> other$hostnameVerifier = other.getHostnameVerifier();
        if (this$hostnameVerifier == null ? other$hostnameVerifier != null : !this$hostnameVerifier.equals(other$hostnameVerifier)) {
            return false;
        }
        Supplier<URLConnectionFactory> this$urlConnectionFactory = this.getUrlConnectionFactory();
        Supplier<URLConnectionFactory> other$urlConnectionFactory = other.getUrlConnectionFactory();
        if (this$urlConnectionFactory == null ? other$urlConnectionFactory != null : !this$urlConnectionFactory.equals(other$urlConnectionFactory)) {
            return false;
        }
        HttpEventListener this$listener = this.getListener();
        HttpEventListener other$listener = other.getListener();
        if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
            return false;
        }
        List<StreamDecoder> this$decoders = this.getDecoders();
        List<StreamDecoder> other$decoders = other.getDecoders();
        if (this$decoders == null ? other$decoders != null : !((Object)this$decoders).equals(other$decoders)) {
            return false;
        }
        HttpAuthenticator this$authenticator = this.getAuthenticator();
        HttpAuthenticator other$authenticator = other.getAuthenticator();
        if (this$authenticator == null ? other$authenticator != null : !this$authenticator.equals(other$authenticator)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        return !(this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getMaxRedirects();
        result = result * 59 + (this.isPreemptiveAuthentication() ? 79 : 97);
        Supplier<ProxySelector> $proxySelector = this.getProxySelector();
        result = result * 59 + ($proxySelector == null ? 43 : $proxySelector.hashCode());
        Supplier<SSLSocketFactory> $sslSocketFactory = this.getSslSocketFactory();
        result = result * 59 + ($sslSocketFactory == null ? 43 : $sslSocketFactory.hashCode());
        Supplier<HostnameVerifier> $hostnameVerifier = this.getHostnameVerifier();
        result = result * 59 + ($hostnameVerifier == null ? 43 : $hostnameVerifier.hashCode());
        Supplier<URLConnectionFactory> $urlConnectionFactory = this.getUrlConnectionFactory();
        result = result * 59 + ($urlConnectionFactory == null ? 43 : $urlConnectionFactory.hashCode());
        HttpEventListener $listener = this.getListener();
        result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
        List<StreamDecoder> $decoders = this.getDecoders();
        result = result * 59 + ($decoders == null ? 43 : ((Object)$decoders).hashCode());
        HttpAuthenticator $authenticator = this.getAuthenticator();
        result = result * 59 + ($authenticator == null ? 43 : $authenticator.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "HttpContext(readTimeout=" + this.getReadTimeout() + ", connectTimeout=" + this.getConnectTimeout() + ", maxRedirects=" + this.getMaxRedirects() + ", proxySelector=" + this.getProxySelector() + ", sslSocketFactory=" + this.getSslSocketFactory() + ", hostnameVerifier=" + this.getHostnameVerifier() + ", urlConnectionFactory=" + this.getUrlConnectionFactory() + ", listener=" + this.getListener() + ", decoders=" + this.getDecoders() + ", authenticator=" + this.getAuthenticator() + ", preemptiveAuthentication=" + this.isPreemptiveAuthentication() + ", userAgent=" + this.getUserAgent() + ")";
    }

    public static final class Builder {
        @Generated
        private boolean readTimeout$set;
        @Generated
        private int readTimeout$value;
        @Generated
        private boolean connectTimeout$set;
        @Generated
        private int connectTimeout$value;
        @Generated
        private boolean maxRedirects$set;
        @Generated
        private int maxRedirects$value;
        @Generated
        private boolean proxySelector$set;
        @Generated
        private Supplier<ProxySelector> proxySelector$value;
        @Generated
        private boolean sslSocketFactory$set;
        @Generated
        private Supplier<SSLSocketFactory> sslSocketFactory$value;
        @Generated
        private boolean hostnameVerifier$set;
        @Generated
        private Supplier<HostnameVerifier> hostnameVerifier$value;
        @Generated
        private boolean urlConnectionFactory$set;
        @Generated
        private Supplier<URLConnectionFactory> urlConnectionFactory$value;
        @Generated
        private boolean listener$set;
        @Generated
        private HttpEventListener listener$value;
        @Generated
        private ArrayList<StreamDecoder> decoders;
        @Generated
        private boolean authenticator$set;
        @Generated
        private HttpAuthenticator authenticator$value;
        @Generated
        private boolean preemptiveAuthentication$set;
        @Generated
        private boolean preemptiveAuthentication$value;
        @Generated
        private boolean userAgent$set;
        @Generated
        private String userAgent$value;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder readTimeout(@NonNegative int readTimeout) {
            this.readTimeout$value = readTimeout;
            this.readTimeout$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder connectTimeout(@NonNegative int connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder maxRedirects(@NonNegative int maxRedirects) {
            this.maxRedirects$value = maxRedirects;
            this.maxRedirects$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder proxySelector(@lombok.NonNull Supplier<ProxySelector> proxySelector) {
            if (proxySelector == null) {
                throw new NullPointerException("proxySelector is marked non-null but is null");
            }
            this.proxySelector$value = proxySelector;
            this.proxySelector$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder sslSocketFactory(@lombok.NonNull Supplier<SSLSocketFactory> sslSocketFactory) {
            if (sslSocketFactory == null) {
                throw new NullPointerException("sslSocketFactory is marked non-null but is null");
            }
            this.sslSocketFactory$value = sslSocketFactory;
            this.sslSocketFactory$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder hostnameVerifier(@lombok.NonNull Supplier<HostnameVerifier> hostnameVerifier) {
            if (hostnameVerifier == null) {
                throw new NullPointerException("hostnameVerifier is marked non-null but is null");
            }
            this.hostnameVerifier$value = hostnameVerifier;
            this.hostnameVerifier$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder urlConnectionFactory(@lombok.NonNull Supplier<URLConnectionFactory> urlConnectionFactory) {
            if (urlConnectionFactory == null) {
                throw new NullPointerException("urlConnectionFactory is marked non-null but is null");
            }
            this.urlConnectionFactory$value = urlConnectionFactory;
            this.urlConnectionFactory$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder listener(@lombok.NonNull HttpEventListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.listener$value = listener;
            this.listener$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder decoder(StreamDecoder decoder) {
            if (this.decoders == null) {
                this.decoders = new ArrayList();
            }
            this.decoders.add(decoder);
            return this;
        }

        @Generated
        public @NonNull Builder decoders(@NonNull Collection<? extends StreamDecoder> decoders) {
            if (decoders == null) {
                throw new NullPointerException("decoders cannot be null");
            }
            if (this.decoders == null) {
                this.decoders = new ArrayList();
            }
            this.decoders.addAll(decoders);
            return this;
        }

        @Generated
        public @NonNull Builder clearDecoders() {
            if (this.decoders != null) {
                this.decoders.clear();
            }
            return this;
        }

        @Generated
        public @NonNull Builder authenticator(@lombok.NonNull HttpAuthenticator authenticator) {
            if (authenticator == null) {
                throw new NullPointerException("authenticator is marked non-null but is null");
            }
            this.authenticator$value = authenticator;
            this.authenticator$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder preemptiveAuthentication(boolean preemptiveAuthentication) {
            this.preemptiveAuthentication$value = preemptiveAuthentication;
            this.preemptiveAuthentication$set = true;
            return this;
        }

        @Generated
        public @NonNull Builder userAgent(String userAgent) {
            this.userAgent$value = userAgent;
            this.userAgent$set = true;
            return this;
        }

        @Generated
        public @NonNull HttpContext build() {
            List<StreamDecoder> decoders;
            switch (this.decoders == null ? 0 : this.decoders.size()) {
                case 0: {
                    decoders = Collections.emptyList();
                    break;
                }
                case 1: {
                    decoders = Collections.singletonList(this.decoders.get(0));
                    break;
                }
                default: {
                    decoders = Collections.unmodifiableList(new ArrayList<StreamDecoder>(this.decoders));
                }
            }
            int readTimeout$value = this.readTimeout$value;
            if (!this.readTimeout$set) {
                readTimeout$value = HttpContext.$default$readTimeout();
            }
            int connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = HttpContext.$default$connectTimeout();
            }
            int maxRedirects$value = this.maxRedirects$value;
            if (!this.maxRedirects$set) {
                maxRedirects$value = HttpContext.$default$maxRedirects();
            }
            Supplier proxySelector$value = this.proxySelector$value;
            if (!this.proxySelector$set) {
                proxySelector$value = HttpContext.$default$proxySelector();
            }
            Supplier sslSocketFactory$value = this.sslSocketFactory$value;
            if (!this.sslSocketFactory$set) {
                sslSocketFactory$value = HttpContext.$default$sslSocketFactory();
            }
            Supplier hostnameVerifier$value = this.hostnameVerifier$value;
            if (!this.hostnameVerifier$set) {
                hostnameVerifier$value = HttpContext.$default$hostnameVerifier();
            }
            Supplier urlConnectionFactory$value = this.urlConnectionFactory$value;
            if (!this.urlConnectionFactory$set) {
                urlConnectionFactory$value = HttpContext.$default$urlConnectionFactory();
            }
            HttpEventListener listener$value = this.listener$value;
            if (!this.listener$set) {
                listener$value = HttpContext.$default$listener();
            }
            HttpAuthenticator authenticator$value = this.authenticator$value;
            if (!this.authenticator$set) {
                authenticator$value = HttpContext.$default$authenticator();
            }
            boolean preemptiveAuthentication$value = this.preemptiveAuthentication$value;
            if (!this.preemptiveAuthentication$set) {
                preemptiveAuthentication$value = HttpContext.$default$preemptiveAuthentication();
            }
            String userAgent$value = this.userAgent$value;
            if (!this.userAgent$set) {
                userAgent$value = HttpContext.$default$userAgent();
            }
            return new HttpContext(readTimeout$value, connectTimeout$value, maxRedirects$value, proxySelector$value, sslSocketFactory$value, hostnameVerifier$value, urlConnectionFactory$value, listener$value, decoders, authenticator$value, preemptiveAuthentication$value, userAgent$value);
        }

        @Generated
        public @NonNull String toString() {
            return "HttpContext.Builder(readTimeout$value=" + this.readTimeout$value + ", connectTimeout$value=" + this.connectTimeout$value + ", maxRedirects$value=" + this.maxRedirects$value + ", proxySelector$value=" + this.proxySelector$value + ", sslSocketFactory$value=" + this.sslSocketFactory$value + ", hostnameVerifier$value=" + this.hostnameVerifier$value + ", urlConnectionFactory$value=" + this.urlConnectionFactory$value + ", listener$value=" + this.listener$value + ", decoders=" + this.decoders + ", authenticator$value=" + this.authenticator$value + ", preemptiveAuthentication$value=" + this.preemptiveAuthentication$value + ", userAgent$value=" + this.userAgent$value + ")";
        }
    }
}

