/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlTable {
    public static final String ALL_CATALOGS = null;
    public static final String ALL_SCHEMAS = null;
    public static final String ALL_TABLE_NAMES = "%";
    public static final String[] ALL_TYPES = null;
    private final String catalog;
    private final String schema;
    @lombok.NonNull
    private final String name;
    @lombok.NonNull
    private final String type;
    private final String remarks;
    private final String typesCatalog;
    private final String typesSchema;
    private final String typeName;
    private final String selfReferencingColumnName;
    private final String refGeneration;

    @lombok.NonNull
    public static List<SqlTable> allOf(@lombok.NonNull DatabaseMetaData md) throws SQLException {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        return SqlTable.allOf(md, ALL_CATALOGS, ALL_SCHEMAS, ALL_TABLE_NAMES, ALL_TYPES);
    }

    @lombok.NonNull
    public static List<SqlTable> allOf(@lombok.NonNull DatabaseMetaData md, @Nullable String catalog, @Nullable String schemaPattern, @lombok.NonNull String tableNamePattern, @Nullable String[] types) throws SQLException {
        Objects.requireNonNull(md, "md");
        Objects.requireNonNull(tableNamePattern, "tableNamePattern");
        try (ResultSet rs = md.getTables(catalog, schemaPattern, tableNamePattern, types);){
            List<SqlTable> list = SqlTable.allOf(rs);
            return list;
        }
    }

    private static List<SqlTable> allOf(ResultSet tables) throws SQLException {
        String[] normalizedColumnNames = SqlTable.getNormalizedColumnNames(tables.getMetaData());
        ArrayList<SqlTable> result = new ArrayList<SqlTable>();
        HashMap<String, String> row = new HashMap<String, String>();
        while (tables.next()) {
            for (int i = 0; i < normalizedColumnNames.length; ++i) {
                row.put(normalizedColumnNames[i], tables.getString(i + 1));
            }
            result.add(SqlTable.fromMap(row));
        }
        return result;
    }

    private static String[] getNormalizedColumnNames(ResultSetMetaData md) throws SQLException {
        String[] columnNames = new String[md.getColumnCount()];
        for (int i = 0; i < columnNames.length; ++i) {
            columnNames[i] = md.getColumnName(i + 1).toUpperCase(Locale.ROOT);
        }
        return columnNames;
    }

    @lombok.NonNull
    private static SqlTable fromMap(@lombok.NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        return new SqlTable(SqlTable.get(map, "TABLE_CAT", "TABLE_CATALOG"), SqlTable.get(map, "TABLE_SCHEM", "TABLE_SCHEMA"), SqlTable.nullToEmpty(SqlTable.get(map, "TABLE_NAME")), SqlTable.nullToEmpty(SqlTable.get(map, "TABLE_TYPE")), SqlTable.get(map, "REMARKS"), SqlTable.get(map, "TYPE_CAT"), SqlTable.get(map, "TYPE_SCHEM"), SqlTable.get(map, "TYPE_NAME"), SqlTable.get(map, "SELF_REFERENCING_COL_NAME"), SqlTable.get(map, "REF_GENERATION"));
    }

    @lombok.NonNull
    private static String nullToEmpty(@Nullable String o) {
        return o == null ? "" : o;
    }

    private static @Nullable String get(@lombok.NonNull Map<String, String> map, String ... keys) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        for (String key : keys) {
            String result = map.get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Generated
    SqlTable(String catalog, String schema, @lombok.NonNull String name, @lombok.NonNull String type, String remarks, String typesCatalog, String typesSchema, String typeName, String selfReferencingColumnName, String refGeneration) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.type = type;
        this.remarks = remarks;
        this.typesCatalog = typesCatalog;
        this.typesSchema = typesSchema;
        this.typeName = typeName;
        this.selfReferencingColumnName = selfReferencingColumnName;
        this.refGeneration = refGeneration;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public String getCatalog() {
        return this.catalog;
    }

    @Generated
    public String getSchema() {
        return this.schema;
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @lombok.NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getRemarks() {
        return this.remarks;
    }

    @Generated
    public String getTypesCatalog() {
        return this.typesCatalog;
    }

    @Generated
    public String getTypesSchema() {
        return this.typesSchema;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getSelfReferencingColumnName() {
        return this.selfReferencingColumnName;
    }

    @Generated
    public String getRefGeneration() {
        return this.refGeneration;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlTable)) {
            return false;
        }
        SqlTable other = (SqlTable)o;
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$remarks = this.getRemarks();
        String other$remarks = other.getRemarks();
        if (this$remarks == null ? other$remarks != null : !this$remarks.equals(other$remarks)) {
            return false;
        }
        String this$typesCatalog = this.getTypesCatalog();
        String other$typesCatalog = other.getTypesCatalog();
        if (this$typesCatalog == null ? other$typesCatalog != null : !this$typesCatalog.equals(other$typesCatalog)) {
            return false;
        }
        String this$typesSchema = this.getTypesSchema();
        String other$typesSchema = other.getTypesSchema();
        if (this$typesSchema == null ? other$typesSchema != null : !this$typesSchema.equals(other$typesSchema)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$selfReferencingColumnName = this.getSelfReferencingColumnName();
        String other$selfReferencingColumnName = other.getSelfReferencingColumnName();
        if (this$selfReferencingColumnName == null ? other$selfReferencingColumnName != null : !this$selfReferencingColumnName.equals(other$selfReferencingColumnName)) {
            return false;
        }
        String this$refGeneration = this.getRefGeneration();
        String other$refGeneration = other.getRefGeneration();
        return !(this$refGeneration == null ? other$refGeneration != null : !this$refGeneration.equals(other$refGeneration));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $remarks = this.getRemarks();
        result = result * 59 + ($remarks == null ? 43 : $remarks.hashCode());
        String $typesCatalog = this.getTypesCatalog();
        result = result * 59 + ($typesCatalog == null ? 43 : $typesCatalog.hashCode());
        String $typesSchema = this.getTypesSchema();
        result = result * 59 + ($typesSchema == null ? 43 : $typesSchema.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $selfReferencingColumnName = this.getSelfReferencingColumnName();
        result = result * 59 + ($selfReferencingColumnName == null ? 43 : $selfReferencingColumnName.hashCode());
        String $refGeneration = this.getRefGeneration();
        result = result * 59 + ($refGeneration == null ? 43 : $refGeneration.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SqlTable(catalog=" + this.getCatalog() + ", schema=" + this.getSchema() + ", name=" + this.getName() + ", type=" + this.getType() + ", remarks=" + this.getRemarks() + ", typesCatalog=" + this.getTypesCatalog() + ", typesSchema=" + this.getTypesSchema() + ", typeName=" + this.getTypeName() + ", selfReferencingColumnName=" + this.getSelfReferencingColumnName() + ", refGeneration=" + this.getRefGeneration() + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private String catalog;
        @Generated
        private String schema;
        @Generated
        private String name;
        @Generated
        private String type;
        @Generated
        private String remarks;
        @Generated
        private String typesCatalog;
        @Generated
        private String typesSchema;
        @Generated
        private String typeName;
        @Generated
        private String selfReferencingColumnName;
        @Generated
        private String refGeneration;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        @Generated
        public @NonNull Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        @Generated
        public @NonNull Builder name(@lombok.NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @NonNull Builder type(@lombok.NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @NonNull Builder remarks(String remarks) {
            this.remarks = remarks;
            return this;
        }

        @Generated
        public @NonNull Builder typesCatalog(String typesCatalog) {
            this.typesCatalog = typesCatalog;
            return this;
        }

        @Generated
        public @NonNull Builder typesSchema(String typesSchema) {
            this.typesSchema = typesSchema;
            return this;
        }

        @Generated
        public @NonNull Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Generated
        public @NonNull Builder selfReferencingColumnName(String selfReferencingColumnName) {
            this.selfReferencingColumnName = selfReferencingColumnName;
            return this;
        }

        @Generated
        public @NonNull Builder refGeneration(String refGeneration) {
            this.refGeneration = refGeneration;
            return this;
        }

        @Generated
        public @NonNull SqlTable build() {
            return new SqlTable(this.catalog, this.schema, this.name, this.type, this.remarks, this.typesCatalog, this.typesSchema, this.typeName, this.selfReferencingColumnName, this.refGeneration);
        }

        @Generated
        public @NonNull String toString() {
            return "SqlTable.Builder(catalog=" + this.catalog + ", schema=" + this.schema + ", name=" + this.name + ", type=" + this.type + ", remarks=" + this.remarks + ", typesCatalog=" + this.typesCatalog + ", typesSchema=" + this.typesSchema + ", typeName=" + this.typeName + ", selfReferencingColumnName=" + this.selfReferencingColumnName + ", refGeneration=" + this.refGeneration + ")";
        }
    }
}

