/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.sql.lhod.LhodConnection;
import internal.sql.lhod.LhodResultSet;
import internal.sql.lhod.TabDataQuery;
import internal.sql.lhod.TabDataRemoteError;
import internal.sql.lhod._Statement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

final class LhodStatement
extends _Statement {
    @lombok.NonNull
    private final LhodConnection conn;
    private boolean closed = false;

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkState();
        TabDataQuery query = TabDataQuery.builder().procedure("PreparedStatement").parameter(this.conn.getConnectionString()).parameter(sql).build();
        try {
            return LhodResultSet.of(this.conn.exec(query));
        }
        catch (IOException ex) {
            throw ex instanceof TabDataRemoteError ? new SQLException(ex.getMessage(), "", ((TabDataRemoteError)ex).getNumber()) : new SQLException(String.format(Locale.ROOT, "Failed to execute query '%s'", sql), ex);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void close() throws SQLException {
        this.closed = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkState();
        return this.conn;
    }

    private void checkState() throws SQLException {
        this.conn.checkState();
        if (this.closed) {
            throw new SQLException("Statement closed");
        }
    }

    @Generated
    private LhodStatement(@lombok.NonNull LhodConnection conn) {
        if (conn == null) {
            throw new NullPointerException("conn is marked non-null but is null");
        }
        this.conn = conn;
    }

    @Generated
    public static @NonNull LhodStatement of(@lombok.NonNull LhodConnection conn) {
        if (conn == null) {
            throw new NullPointerException("conn is marked non-null but is null");
        }
        return new LhodStatement(conn);
    }
}

