/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet;

import ec.util.spreadsheet.Sheet;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class Book
implements Closeable {
    public @NonNegative int getSheetCount2() throws IOException {
        try {
            return this.getSheetCount();
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    @Deprecated
    public abstract int getSheetCount();

    public abstract @NonNull Sheet getSheet(@NonNegative int var1) throws IOException, IndexOutOfBoundsException;

    public @NonNull String getSheetName(@NonNegative int index) throws IOException, IndexOutOfBoundsException {
        return this.getSheet(index).getName();
    }

    public void forEach(@NonNull ObjIntConsumer<? super Sheet> action) throws IOException {
        Objects.requireNonNull(action);
        for (int index = 0; index < this.getSheetCount2(); ++index) {
            action.accept(this.getSheet(index), index);
        }
    }

    public void parallelForEach(@NonNull ObjIntConsumer<? super Sheet> action) throws IOException {
        this.forEach(action);
    }

    @Override
    public void close() throws IOException {
    }

    private static IOException translate(FileNotFoundException ex) {
        String msg = ex.getMessage();
        if (msg != null && !msg.isEmpty()) {
            return new NoSuchFileException(msg);
        }
        return ex;
    }

    public static abstract class Factory
    implements FileFilter,
    DirectoryStream.Filter<Path> {
        public static final int NATIVE_RANK = 127;
        public static final int WRAPPED_RANK = 0;
        public static final int UNKNOWN_RANK = -1;

        public abstract @NonNull String getName();

        public int getRank() {
            return -1;
        }

        public boolean canLoad() {
            return true;
        }

        public @NonNull Book load(@NonNull Path file) throws IOException {
            try {
                return this.load(file.toFile());
            }
            catch (UnsupportedOperationException ex) {
                try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                    Book book = this.load(stream);
                    return book;
                }
            }
        }

        public @NonNull Book load(@NonNull File file) throws IOException {
            Book book;
            FileInputStream stream = new FileInputStream(file);
            try {
                book = this.load(stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    throw Book.translate(ex);
                }
            }
            ((InputStream)stream).close();
            return book;
        }

        @Deprecated
        public @NonNull Book load(@NonNull URL url) throws IOException {
            Book book;
            block8: {
                InputStream stream = url.openStream();
                try {
                    book = this.load(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException ex) {
                        throw Book.translate(ex);
                    }
                }
                stream.close();
            }
            return book;
        }

        public abstract @NonNull Book load(@NonNull InputStream var1) throws IOException;

        public boolean canStore() {
            return true;
        }

        public void store(@NonNull Path file, @NonNull Book book) throws IOException {
            try {
                this.store(file.toFile(), book);
            }
            catch (UnsupportedOperationException ex) {
                try (OutputStream stream = Files.newOutputStream(file, new OpenOption[0]);){
                    this.store(stream, book);
                }
            }
        }

        public void store(@NonNull File file, @NonNull Book book) throws IOException {
            try (FileOutputStream stream = new FileOutputStream(file, false);){
                this.store(stream, book);
            }
        }

        public abstract void store(@NonNull OutputStream var1, @NonNull Book var2) throws IOException;

        public @NonNull Map<String, List<String>> getExtensionsByMediaType() {
            return Collections.emptyMap();
        }

        @Override
        public boolean accept(Path entry) throws IOException {
            try {
                return this.accept(entry.toFile());
            }
            catch (UnsupportedOperationException ex) {
                return false;
            }
        }

        public boolean isSupportedDataType(@NonNull Class<?> type) {
            return Date.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || String.class.isAssignableFrom(type);
        }
    }
}

