/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet;

import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.SheetConsumer;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class Sheet {
    public abstract @NonNegative int getRowCount();

    public abstract @NonNegative int getColumnCount();

    @Deprecated
    public abstract @Nullable Cell getCell(@NonNegative int var1, @NonNegative int var2) throws IndexOutOfBoundsException;

    public @Nullable Object getCellValue(@NonNegative int rowIdx, @NonNegative int columnIdx) throws IndexOutOfBoundsException {
        return Sheet.getCellValueFromCell(this, rowIdx, columnIdx);
    }

    @Deprecated
    public void forEach(@NonNull SheetConsumer<? super Cell> action) {
        Sheet.forEachByRow(this, action);
    }

    public void forEachValue(@NonNull SheetConsumer<? super Object> action) {
        Sheet.forEachValueByRow(this, action);
    }

    public abstract @NonNull String getName();

    @Deprecated
    public @NonNull Sheet inv() {
        return Sheet.invUsingDelegate(this);
    }

    private static void forEachByRow(@NonNull Sheet sheet, @NonNull SheetConsumer<? super Cell> action) {
        Objects.requireNonNull(action);
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Cell cell = sheet.getCell(i, j);
                if (cell == null) continue;
                action.accept(i, j, cell);
            }
        }
    }

    private static void forEachValueByRow(@NonNull Sheet sheet, @NonNull SheetConsumer<? super Object> action) {
        Objects.requireNonNull(action);
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                Object value = sheet.getCellValue(i, j);
                if (value == null) continue;
                action.accept(i, j, value);
            }
        }
    }

    private static @Nullable Object getCellValueFromCell(@NonNull Sheet sheet, int rowIdx, int columnIdx) {
        Cell cell = sheet.getCell(rowIdx, columnIdx);
        return cell != null ? cell.getValue() : null;
    }

    private static @NonNull Sheet invUsingDelegate(@NonNull Sheet sheet) {
        return sheet instanceof InvSheet ? ((InvSheet)sheet).sheet : new InvSheet(sheet);
    }

    private static final class InvSheet
    extends Sheet {
        private final Sheet sheet;

        public InvSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getColumnCount();
        }

        @Override
        public int getColumnCount() {
            return this.sheet.getRowCount();
        }

        @Override
        public Cell getCell(int rowIdx, int columnIdx) {
            return this.sheet.getCell(columnIdx, rowIdx);
        }

        @Override
        public Object getCellValue(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
            return this.sheet.getCellValue(columnIdx, rowIdx);
        }

        @Override
        public void forEach(SheetConsumer<? super Cell> action) {
            this.sheet.forEach((i, j, c) -> action.accept(j, i, (Cell)c));
        }

        @Override
        public void forEachValue(SheetConsumer<? super Object> action) {
            this.sheet.forEachValue((i, j, v) -> action.accept(j, i, v));
        }

        @Override
        public String getName() {
            return this.sheet.getName();
        }
    }
}

