/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.helpers;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArraySheet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ArrayBook
extends Book
implements Serializable {
    private final ArraySheet[] sheets;

    ArrayBook(@NonNull ArraySheet[] sheets) {
        this.sheets = sheets;
    }

    @Override
    public @NonNegative int getSheetCount2() {
        return this.sheets.length;
    }

    @Override
    public int getSheetCount() {
        return this.sheets.length;
    }

    @Override
    public @NonNull ArraySheet getSheet(int sheetIndex) {
        return this.sheets[sheetIndex];
    }

    @Override
    public @NonNull String getSheetName(int index) {
        return this.sheets[index].getName();
    }

    @Override
    public void forEach(@NonNull ObjIntConsumer<? super Sheet> action) {
        Objects.requireNonNull(action);
        for (int index = 0; index < this.getSheetCount2(); ++index) {
            action.accept(this.getSheet(index), index);
        }
    }

    @Override
    public void close() {
    }

    public @NonNull ArrayBook copy() {
        ArraySheet[] result = new ArraySheet[this.getSheetCount2()];
        for (int s = 0; s < result.length; ++s) {
            result[s] = this.getSheet(s).copy();
        }
        return new ArrayBook(result);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ArrayBook && this.equals((ArrayBook)obj);
    }

    private boolean equals(ArrayBook that) {
        return Arrays.equals(this.sheets, that.sheets);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sheets);
    }

    public String toString() {
        return "ArrayBook[" + this.sheets.length + "]";
    }

    public static @NonNull ArrayBook copyOf(@NonNull Book book) throws IOException {
        if (book instanceof ArrayBook) {
            return ((ArrayBook)book).copy();
        }
        ArraySheet[] sheets = new ArraySheet[book.getSheetCount2()];
        for (int s = 0; s < sheets.length; ++s) {
            sheets[s] = ArraySheet.copyOf(book.getSheet(s));
        }
        return new ArrayBook(sheets);
    }

    public static @NonNull Builder builder() {
        return new ListBuilder();
    }

    private static final class ListBuilder
    extends Builder {
        private final List<ArraySheet> sheets = new ArrayList<ArraySheet>();

        private ListBuilder() {
        }

        @Override
        public Builder clear() {
            this.sheets.clear();
            return this;
        }

        @Override
        public Builder book(Book book) throws IOException {
            for (int i = 0; i < book.getSheetCount2(); ++i) {
                this.sheet(book.getSheet(i));
            }
            return this;
        }

        @Override
        public Builder sheet(Sheet sheet) {
            this.sheets.add(ArraySheet.copyOf(sheet));
            return this;
        }

        @Override
        public ArrayBook build() {
            return new ArrayBook(this.sheets.toArray(new ArraySheet[this.sheets.size()]));
        }
    }

    public static abstract class Builder {
        public abstract @NonNull Builder clear();

        public abstract @NonNull Builder book(@NonNull Book var1) throws IOException;

        public abstract @NonNull Builder sheet(@NonNull Sheet var1);

        public abstract @NonNull ArrayBook build();
    }
}

