/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.helpers;

import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.SheetConsumer;
import ec.util.spreadsheet.helpers.ArrayBook;
import ec.util.spreadsheet.helpers.CellRefHelper;
import ec.util.spreadsheet.helpers.PrivateIntList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ArraySheet
extends Sheet
implements Serializable {
    private final String name;
    private final int rowCount;
    private final int columnCount;
    private final Serializable[] values;
    @Deprecated
    private final FlyweightCell flyweightCell;
    private final boolean inv;

    ArraySheet(@NonNull String name, int rowCount, int columnCount, @NonNull Serializable[] values, boolean inv) {
        this.name = Objects.requireNonNull(name);
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.values = Objects.requireNonNull(values);
        this.flyweightCell = new FlyweightCell();
        this.inv = inv;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Object getCellValue(int rowIndex, int columnIndex) throws IndexOutOfBoundsException {
        return !this.inv ? this.values[rowIndex * this.columnCount + columnIndex] : this.values[columnIndex * this.rowCount + rowIndex];
    }

    @Override
    public Cell getCell(int rowIndex, int columnIndex) throws IndexOutOfBoundsException {
        Object value = this.getCellValue(rowIndex, columnIndex);
        return value != null ? this.flyweightCell.withValue(value) : null;
    }

    @Override
    public void forEach(SheetConsumer<? super Cell> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                Object value = this.getCellValue(i, j);
                if (value == null) continue;
                action.accept(i, j, this.flyweightCell.withValue(value));
            }
        }
    }

    @Override
    public void forEachValue(SheetConsumer<? super Object> action) {
        Objects.requireNonNull(action);
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                Object value = this.getCellValue(i, j);
                if (value == null) continue;
                action.accept(i, j, value);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArraySheet inv() {
        return new ArraySheet(this.name, this.columnCount, this.rowCount, this.values, !this.inv);
    }

    public @NonNull ArraySheet rename(@NonNull String name) {
        return this.name.equals(name) ? this : new ArraySheet(name, this.rowCount, this.columnCount, this.values, this.inv);
    }

    public @NonNull ArraySheet copy() {
        return new ArraySheet(this.name, this.rowCount, this.columnCount, this.values, this.inv);
    }

    public @NonNull ArrayBook toBook() {
        return new ArrayBook(new ArraySheet[]{this.copy()});
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ArraySheet && this.equals((ArraySheet)obj);
    }

    private boolean equals(ArraySheet that) {
        return this.name.equals(that.name) && this.rowCount == that.rowCount && this.columnCount == that.columnCount && this.valuesEquals(that);
    }

    private boolean valuesEquals(ArraySheet that) {
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                if (Objects.equals(this.getCellValue(i, j), that.getCellValue(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.name.hashCode(), this.rowCount, this.columnCount, this.valuesHashCode()});
    }

    private int valuesHashCode() {
        int result = 1;
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                Object o = this.getCellValue(i, j);
                result = 31 * result + (o == null ? 0 : o.hashCode());
            }
        }
        return result;
    }

    public String toString() {
        return "ArraySheet{" + this.name + "}[" + this.rowCount + "x" + this.columnCount + "]";
    }

    public static @NonNull ArraySheet copyOf(@NonNull Sheet sheet) {
        return sheet instanceof ArraySheet ? ((ArraySheet)sheet).copy() : new ArraySheet(sheet.getName(), sheet.getRowCount(), sheet.getColumnCount(), ArraySheet.copyValuesOf(sheet), false);
    }

    public static @NonNull ArraySheet copyOf(@NonNull String name, @NonNull Object[][] table) {
        int rowCount = table.length;
        int columnCount = 0;
        for (Object[] row : table) {
            if (row == null || columnCount >= row.length) continue;
            columnCount = row.length;
        }
        Serializable[] values = new Serializable[rowCount * columnCount];
        for (int i = 0; i < table.length; ++i) {
            if (table[i] == null) continue;
            for (int j = 0; j < table[i].length; ++j) {
                values[i * columnCount + j] = ArraySheet.unknownToString(table[i][j]);
            }
        }
        return new ArraySheet(name, rowCount, columnCount, values, false);
    }

    public static @NonNull Builder builder() {
        return new UnboundedBuilder();
    }

    public static @NonNull Builder builder(int rowCount, int columnCount) {
        return new BoundedBuilder(rowCount, columnCount);
    }

    public static @NonNull Builder builder(@Nullable String sheetBounds) {
        CellRefHelper helper = new CellRefHelper();
        return helper.parseEnd(sheetBounds) ? ArraySheet.builder(helper.getRowIndex() + 1, helper.getColumnIndex() + 1) : ArraySheet.builder();
    }

    private static @NonNull Serializable[] copyValuesOf(@NonNull Sheet sheet) {
        int rowCount = sheet.getRowCount();
        int columnCount = sheet.getColumnCount();
        Serializable[] result = new Serializable[rowCount * columnCount];
        sheet.forEachValue((i, j, v) -> {
            result[i * columnCount + j] = (Serializable)v;
        });
        return result;
    }

    private static Builder rowByValue(Builder b, int row, int column, Iterator<?> values) throws IndexOutOfBoundsException {
        int j = 0;
        while (values.hasNext()) {
            b.value(row, column + j, values.next());
            ++j;
        }
        return b;
    }

    private static Builder columnByValue(Builder b, int row, int column, Iterator<?> values) throws IndexOutOfBoundsException {
        int i = 0;
        while (values.hasNext()) {
            b.value(row + i, column, values.next());
            ++i;
        }
        return b;
    }

    private static Builder tableByRow(Builder b, int row, int column, Object[][] values) {
        for (int i = 0; i < values.length; ++i) {
            Object[] tmp = values[i];
            if (tmp == null) continue;
            for (int j = 0; j < tmp.length; ++j) {
                b.value(row + i, column + j, tmp[j]);
            }
        }
        return b;
    }

    private static Builder tableByValue(Builder b, int row, int column, Sheet values) {
        for (int i = 0; i < values.getRowCount(); ++i) {
            for (int j = 0; j < values.getColumnCount(); ++j) {
                b.value(row + i, column + j, values.getCellValue(i, j));
            }
        }
        return b;
    }

    private static @NonNull Builder mapByRow(Builder b, int rowIndex, int columnIndex, @NonNull Map<?, ?> map) {
        int i = 0;
        for (Map.Entry<?, ?> o : map.entrySet()) {
            b.row(rowIndex + i++, columnIndex, o.getKey(), o.getValue());
        }
        return b;
    }

    private static Serializable unknownToString(Object input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Date) {
            return (Date)input;
        }
        if (input instanceof Number) {
            return Double.valueOf(input instanceof Double ? ((Double)input).doubleValue() : ((Number)input).doubleValue());
        }
        if (input instanceof String) {
            return (String)input;
        }
        return input.toString();
    }

    public static abstract class Builder {
        public abstract @NonNull Builder name(@NonNull String var1);

        public abstract @NonNull Builder clear();

        public abstract @NonNull Builder value(int var1, int var2, @Nullable Object var3) throws IndexOutOfBoundsException;

        @Deprecated
        public @NonNull Builder value(int row, int column, @Nullable Cell value) throws IndexOutOfBoundsException {
            Object tmp = value == null ? null : value.getValue();
            return this.value(row, column, tmp);
        }

        public @NonNull Builder row(int row, int column, @NonNull Object first, Object ... rest) throws IndexOutOfBoundsException {
            return this.value(row, column, first).row(row, column + 1, rest);
        }

        public @NonNull Builder row(int row, int column, @NonNull Object[] values) throws IndexOutOfBoundsException {
            return this.row(row, column, Arrays.asList(values));
        }

        public @NonNull Builder row(int row, int column, @NonNull Iterable<?> values) throws IndexOutOfBoundsException {
            return this.row(row, column, values.iterator());
        }

        public @NonNull Builder row(int row, int column, @NonNull Iterator<?> values) throws IndexOutOfBoundsException {
            return ArraySheet.rowByValue(this, row, column, values);
        }

        public @NonNull Builder column(int row, int column, @NonNull Object first, Object ... rest) throws IndexOutOfBoundsException {
            return this.value(row, column, first).column(row + 1, column, rest);
        }

        public @NonNull Builder column(int row, int column, @NonNull Object[] values) throws IndexOutOfBoundsException {
            return this.column(row, column, Arrays.asList(values));
        }

        public @NonNull Builder column(int row, int column, @NonNull Iterable<?> values) throws IndexOutOfBoundsException {
            return this.column(row, column, values.iterator());
        }

        public @NonNull Builder column(int row, int column, @NonNull Iterator<?> values) throws IndexOutOfBoundsException {
            return ArraySheet.columnByValue(this, row, column, values);
        }

        public @NonNull Builder table(int row, int column, @NonNull Object[][] values) throws IndexOutOfBoundsException {
            return ArraySheet.tableByRow(this, row, column, values);
        }

        public @NonNull Builder table(int row, int column, @NonNull Sheet values) throws IndexOutOfBoundsException {
            return ArraySheet.tableByValue(this, row, column, values);
        }

        public @NonNull Builder map(int row, int column, @NonNull Map<?, ?> values) throws IndexOutOfBoundsException {
            return ArraySheet.mapByRow(this, row, column, values);
        }

        public abstract @NonNull ArraySheet build();
    }

    @Deprecated
    static final class FlyweightCell
    extends Cell
    implements Serializable {
        private transient Object value = null;

        FlyweightCell() {
        }

        public @NonNull FlyweightCell withValue(@NonNull Object value) {
            this.value = value;
            return this;
        }

        @Override
        public boolean isDate() {
            return this.value instanceof Date;
        }

        @Override
        public boolean isNumber() {
            return this.value instanceof Number;
        }

        @Override
        public boolean isString() {
            return this.value instanceof String;
        }

        @Override
        public Date getDate() {
            try {
                return (Date)this.value;
            }
            catch (ClassCastException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }

        @Override
        public Number getNumber() {
            try {
                return (Number)this.value;
            }
            catch (ClassCastException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }

        @Override
        public String getString() {
            try {
                return (String)this.value;
            }
            catch (ClassCastException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "Null";
        }
    }

    private static final class UnboundedBuilder
    extends Builder {
        private final List<Serializable> valuesAsList = new ArrayList<Serializable>();
        private final PrivateIntList rows = new PrivateIntList();
        private final PrivateIntList cols = new PrivateIntList();
        private int maxRowIndex = -1;
        private int maxColumnIndex = -1;
        private String name = "";

        @Override
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public Builder clear() {
            this.valuesAsList.clear();
            this.rows.clear();
            this.cols.clear();
            this.maxRowIndex = -1;
            this.maxColumnIndex = -1;
            this.name = "";
            return this;
        }

        @Override
        public Builder value(int rowIndex, int columnIndex, Object value) {
            if (this.maxRowIndex < rowIndex) {
                this.maxRowIndex = rowIndex;
            }
            if (this.maxColumnIndex < columnIndex) {
                this.maxColumnIndex = columnIndex;
            }
            this.valuesAsList.add(ArraySheet.unknownToString(value));
            this.rows.add(rowIndex);
            this.cols.add(columnIndex);
            return this;
        }

        @Override
        public Builder row(int rowIndex, int columnIndex, Object[] row) {
            int lastColumnIndex;
            if (row.length == 0) {
                return this;
            }
            if (this.maxRowIndex < rowIndex) {
                this.maxRowIndex = rowIndex;
            }
            if (this.maxColumnIndex < (lastColumnIndex = columnIndex + row.length - 1)) {
                this.maxColumnIndex = lastColumnIndex;
            }
            for (int j = 0; j < row.length; ++j) {
                this.valuesAsList.add(ArraySheet.unknownToString(row[j]));
                this.rows.add(rowIndex);
                this.cols.add(columnIndex + j);
            }
            return this;
        }

        @Override
        public ArraySheet build() {
            int rowCount = this.maxRowIndex + 1;
            int columnCount = this.maxColumnIndex + 1;
            Serializable[] values = new Serializable[rowCount * columnCount];
            for (int i = 0; i < this.valuesAsList.size(); ++i) {
                int index = this.rows.get(i) * columnCount + this.cols.get(i);
                values[index] = this.valuesAsList.get(i);
            }
            return new ArraySheet(this.name, rowCount, columnCount, values, false);
        }
    }

    private static final class BoundedBuilder
    extends Builder {
        private final int rowCount;
        private final int columnCount;
        private final Serializable[] values;
        private String name;

        public BoundedBuilder(int rowCount, int columnCount) {
            this.rowCount = rowCount;
            this.columnCount = columnCount;
            this.values = new Serializable[rowCount * columnCount];
            this.name = "";
        }

        @Override
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @Override
        public Builder clear() {
            Arrays.fill(this.values, null);
            this.name = "";
            return this;
        }

        @Override
        public Builder value(int rowIndex, int columnIndex, Object value) {
            this.values[rowIndex * this.columnCount + columnIndex] = ArraySheet.unknownToString(value);
            return this;
        }

        @Override
        public ArraySheet build() {
            return new ArraySheet(this.name, this.rowCount, this.columnCount, (Serializable[])this.values.clone(), false);
        }
    }
}

