/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FileHelper {
    private static boolean hasExtension(String filename, String ... exts) {
        switch (exts.length) {
            case 1: {
                return filename.endsWith(exts[0]);
            }
        }
        for (String o : exts) {
            if (!filename.endsWith(o)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasExtension(@NonNull Path file, String ... exts) {
        String filename = file.getName(file.getNameCount() - 1).toString().toLowerCase(Locale.ROOT);
        return FileHelper.hasExtension(filename, exts);
    }

    public static boolean hasExtension(@NonNull File file, String ... exts) {
        String filename = file.getName().toLowerCase(Locale.ROOT);
        return FileHelper.hasExtension(filename, exts);
    }

    private static boolean hasMagicNumber(InputStream stream, byte ... header) throws IOException {
        byte[] actual = new byte[header.length];
        return header.length == stream.read(actual) && Arrays.equals(actual, header);
    }

    public static boolean hasMagicNumber(@NonNull Path file, byte ... header) {
        boolean bl;
        block8: {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            try {
                bl = FileHelper.hasMagicNumber(stream, header);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            stream.close();
        }
        return bl;
    }

    public static boolean hasMagicNumber(@NonNull File file, byte ... header) {
        boolean bl;
        FileInputStream stream = new FileInputStream(file);
        try {
            bl = FileHelper.hasMagicNumber(stream, header);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        ((InputStream)stream).close();
        return bl;
    }

    public static boolean accept(@NonNull File file,  @NonNull DirectoryStream.Filter<Path> delegate) {
        try {
            return delegate.accept(file.toPath());
        }
        catch (IOException | InvalidPathException ex) {
            return false;
        }
    }

    @Generated
    private FileHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

