/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.od;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.FileHelper;
import ec.util.spreadsheet.od.OdBook;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import standalone_spreadsheet.com.github.miachm.sods.NotAnOdsException;
import standalone_spreadsheet.com.github.miachm.sods.Range;
import standalone_spreadsheet.com.github.miachm.sods.SpreadSheet;

public class OpenDocumentBookFactory
extends Book.Factory {
    private static final String ODS_TYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private static final byte[] ZIP_HEADER = new byte[]{80, 75};

    public @NonNull String getName() {
        return "Open Document";
    }

    public int getRank() {
        return 0;
    }

    public @NonNull Map<String, List<String>> getExtensionsByMediaType() {
        return Collections.singletonMap(ODS_TYPE, Collections.singletonList(".ods"));
    }

    public boolean accept(File file) {
        return FileHelper.accept((File)file, this::accept);
    }

    public boolean accept(Path file) throws IOException {
        return FileHelper.hasExtension((Path)file, (String[])new String[]{".ods"}) && (!Files.exists(file, new LinkOption[0]) || FileHelper.hasMagicNumber((Path)file, (byte[])ZIP_HEADER));
    }

    public @NonNull Book load(@NonNull File file) throws IOException {
        OpenDocumentBookFactory.checkFile(file);
        try {
            return new OdBook(new SpreadSheet(file));
        }
        catch (NotAnOdsException ex) {
            throw new IOException(file.getPath(), ex);
        }
    }

    public @NonNull Book load(@NonNull InputStream stream) throws IOException {
        if (stream.available() == 0) {
            throw new EOFException();
        }
        try {
            return new OdBook(new SpreadSheet(stream));
        }
        catch (NotAnOdsException ex) {
            throw new IOException(ex);
        }
    }

    public boolean canStore() {
        return true;
    }

    public void store(@NonNull File file, @NonNull Book book) throws IOException {
        OpenDocumentBookFactory.toSpreadSheet(book).save(file);
    }

    public void store(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        OpenDocumentBookFactory.toSpreadSheet(book).save(stream);
    }

    private static SpreadSheet toSpreadSheet(Book book) throws IOException {
        SpreadSheet result = new SpreadSheet();
        for (int s = 0; s < book.getSheetCount2(); ++s) {
            result.appendSheet(OpenDocumentBookFactory.toSheet(book.getSheet(s)));
        }
        return result;
    }

    private static standalone_spreadsheet.com.github.miachm.sods.Sheet toSheet(Sheet sheet) {
        standalone_spreadsheet.com.github.miachm.sods.Sheet result = new standalone_spreadsheet.com.github.miachm.sods.Sheet(sheet.getName());
        result.deleteRow(0);
        result.deleteColumn(0);
        result.appendRows(sheet.getRowCount());
        result.appendColumns(sheet.getColumnCount());
        Range data = result.getDataRange();
        sheet.forEachValue((i, j, value) -> data.getCell(i, j).setValue(OpenDocumentBookFactory.toCellValue(value)));
        return result;
    }

    private static Object toCellValue(Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        return obj;
    }

    private static @NonNull File checkFile(@NonNull File file) throws IOException {
        if (!file.exists()) {
            throw new NoSuchFileException(file.getPath());
        }
        if (!file.canRead() || file.isDirectory()) {
            throw new AccessDeniedException(file.getPath());
        }
        if (file.length() == 0L) {
            throw new EOFException(file.getPath());
        }
        return file;
    }
}

