/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.xmlss;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.helpers.FileHelper;
import ec.util.spreadsheet.xmlss.XmlssBookReader;
import ec.util.spreadsheet.xmlss.XmlssBookWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.checkerframework.checker.nullness.qual.NonNull;
import standalone_spreadsheet.nbbrd.io.xml.Stax;

public class XmlssBookFactory
extends Book.Factory {
    private static final String XMLSS_TYPE = "application/xml";
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();
    static final String XML_HEADER_TARGET = "mso-application";
    static final String XML_HEADER_DATA = "progid=\"Excel.Sheet\"";

    public @NonNull String getName() {
        return "XML Spreadsheet (XMLSS)";
    }

    public int getRank() {
        return 127;
    }

    public @NonNull Map<String, List<String>> getExtensionsByMediaType() {
        return Collections.singletonMap(XMLSS_TYPE, Collections.singletonList(".xml"));
    }

    public boolean accept(File file) {
        return FileHelper.accept((File)file, this::accept);
    }

    public boolean accept(Path file) throws IOException {
        return FileHelper.hasExtension((Path)file, (String[])new String[]{".xml"}) && (!Files.exists(file, new LinkOption[0]) || XmlssBookFactory.hasValidHeader(file));
    }

    public @NonNull Book load(@NonNull File file) throws IOException {
        return XmlssBookReader.parseFile(file);
    }

    public @NonNull Book load(@NonNull InputStream stream) throws IOException {
        return XmlssBookReader.parseStream(stream);
    }

    public void store(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        this.newWriter().write(stream, book);
    }

    private XmlssBookWriter newWriter() {
        return new XmlssBookWriter(this.xof, StandardCharsets.UTF_8);
    }

    private static boolean hasValidHeader(Path file) {
        try {
            return (Boolean)Stax.StreamParser.valueOf(XmlssBookFactory::hasValidHeader).parsePath(file);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static boolean hasValidHeader(XMLStreamReader xml) throws XMLStreamException {
        while (xml.hasNext()) {
            switch (xml.next()) {
                case 3: {
                    return XML_HEADER_TARGET.equals(xml.getPITarget()) && XML_HEADER_DATA.equals(xml.getPIData());
                }
                case 1: {
                    return false;
                }
            }
        }
        return false;
    }
}

