/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.fastexcel;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.FileHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import standalone_spreadsheet.org.dhatim.fastexcel.StyleSetter;
import standalone_spreadsheet.org.dhatim.fastexcel.Workbook;
import standalone_spreadsheet.org.dhatim.fastexcel.Worksheet;

public final class FastExcelBookFactory
extends Book.Factory {
    private static final String XLSX_TYPE = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    private static final byte[] ZIP_HEADER = new byte[]{80, 75};

    public @NonNull String getName() {
        return "Excel Workbook";
    }

    public int getRank() {
        return 1;
    }

    public @NonNull Map<String, List<String>> getExtensionsByMediaType() {
        return Collections.singletonMap(XLSX_TYPE, Collections.singletonList(".xlsx"));
    }

    public boolean accept(File file) {
        return FileHelper.accept((File)file, (DirectoryStream.Filter)((Object)this));
    }

    public boolean accept(Path file) throws IOException {
        return FileHelper.hasExtension((Path)file, (String[])new String[]{".xlsx"}) && (!Files.exists(file, new LinkOption[0]) || FileHelper.hasMagicNumber((Path)file, (byte[])ZIP_HEADER));
    }

    public boolean canLoad() {
        return false;
    }

    public @NonNull Book load(@NonNull InputStream stream) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public boolean canStore() {
        return true;
    }

    public void store(@NonNull OutputStream stream, @NonNull Book book) throws IOException {
        try (Workbook workbook = new Workbook(stream, "spreadsheet4j", null);){
            FastExcelBookFactory.writeBookData(workbook, book);
        }
    }

    private static void writeBookData(Workbook workbook, Book book) throws IOException {
        for (int s = 0; s < book.getSheetCount2(); ++s) {
            Sheet sheet = book.getSheet(s);
            try (Worksheet worksheet = workbook.newWorksheet(sheet.getName());){
                FastExcelBookFactory.writeSheetData(worksheet, sheet);
                continue;
            }
        }
    }

    private static void writeSheetData(Worksheet worksheet, Sheet sheet) {
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            for (int j = 0; j < sheet.getColumnCount(); ++j) {
                Object cellValue = sheet.getCellValue(i, j);
                if (cellValue instanceof Number) {
                    worksheet.value(i, j, (Number)cellValue);
                    continue;
                }
                if (cellValue instanceof Date) {
                    worksheet.value(i, j, (Date)cellValue);
                    ((StyleSetter)worksheet.style(i, j).format("yyyy-MM-dd H:mm:ss")).set();
                    continue;
                }
                if (!(cellValue instanceof String)) continue;
                worksheet.value(i, j, (String)cellValue);
            }
        }
    }
}

