/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import spreadsheet.xlsx.XlsxDataType;

public interface XlsxEntryParser
extends Closeable {
    public void visitWorkbook(InputStream var1, WorkbookVisitor var2) throws IOException;

    public void visitSharedStrings(InputStream var1, SharedStringsVisitor var2) throws IOException;

    public void visitStyles(InputStream var1, StylesVisitor var2) throws IOException;

    public void visitSheet(InputStream var1, SheetVisitor var2) throws IOException;

    public static interface Factory {
        public @NonNull XlsxEntryParser create() throws IOException;
    }

    public static interface SheetVisitor {
        public void onSheetData(@Nullable String var1) throws IllegalStateException;

        public void onCell(@NonNull String var1, @NonNull CharSequence var2, @NonNull XlsxDataType var3, int var4) throws IllegalStateException;
    }

    public static interface StylesVisitor {
        public void onNumberFormat(int var1, String var2) throws IllegalStateException;

        public void onCellFormat(int var1) throws IllegalStateException;
    }

    public static interface SharedStringsVisitor {
        public void onSharedString(@NonNull String var1);
    }

    public static interface WorkbookVisitor {
        public void onSheet(@NonNull String var1, @NonNull String var2);

        public void onDate1904(boolean var1);
    }
}

