/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.Sheet;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class CompactSheet
extends Sheet {
    private static final int CELL_BYTES = 9;
    private static final int VALUE_OFFSET = 1;
    private final int rowCount;
    private final int columnCount;
    private final String name;
    private final ByteBuffer data;
    private final List<String> sharedStrings;
    private final List<String> localStrings;
    @Deprecated
    private final FlyweightCell flyweightCell = new FlyweightCell();

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Cell getCell(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        int index = this.getIndex(rowIdx, columnIdx);
        return this.getTypeAt(index) != Type.NULL ? this.flyweightCell.withValue(index) : null;
    }

    public Object getCellValue(int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        int index = this.getIndex(rowIdx, columnIdx);
        return this.getValueAt(index);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "CompactSheet[" + this.rowCount + "x" + this.columnCount + "]";
    }

    private int getIndex(int rowIdx, int columnIdx) {
        if (columnIdx >= this.columnCount) {
            throw new IndexOutOfBoundsException();
        }
        return (rowIdx * this.columnCount + columnIdx) * 9;
    }

    private Type getTypeAt(int index) {
        return Type.of(this.data.get(index));
    }

    private Object getValueAt(int index) {
        switch (this.getTypeAt(index).ordinal()) {
            case 2: {
                return this.getDateAt(index);
            }
            case 0: {
                return null;
            }
            case 1: {
                return this.getNumberAt(index);
            }
            case 3: {
                return this.getSharedStringAt(index);
            }
            case 4: {
                return this.getLocalStringAt(index);
            }
        }
        throw new RuntimeException();
    }

    private Date getDateAt(int index) {
        return new Date(this.data.getLong(index + 1));
    }

    private double getNumberAt(int index) {
        return this.data.getDouble(index + 1);
    }

    private String getSharedStringAt(int index) {
        return this.sharedStrings.get(this.data.getInt(index + 1));
    }

    private String getLocalStringAt(int index) {
        return this.localStrings.get(this.data.getInt(index + 1));
    }

    public static @NonNull Builder builder(@NonNegative int rowCount, @NonNegative int columnCount, @NonNull String name, @NonNull List<String> sharedStrings) {
        return new Builder(rowCount, columnCount, name, sharedStrings);
    }

    public static boolean isOverflow(int rowCount, int columnCount) {
        long result = (long)rowCount * (long)columnCount * 9L;
        return (long)((int)result) != result;
    }

    @Generated
    private CompactSheet(int rowCount, int columnCount, String name, ByteBuffer data, List<String> sharedStrings, List<String> localStrings) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.name = name;
        this.data = data;
        this.sharedStrings = sharedStrings;
        this.localStrings = localStrings;
    }

    private static enum Type {
        NULL,
        NUMBER,
        DATE,
        SHARED_STRING,
        LOCAL_STRING;

        private static final Type[] VALUES;

        public static Type of(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = Type.values();
        }
    }

    @Deprecated
    private final class FlyweightCell
    extends Cell
    implements Serializable {
        private int index = -1;
        private Type type = Type.NULL;

        private FlyweightCell() {
        }

        @NonNull FlyweightCell withValue(int index) {
            this.index = index;
            this.type = CompactSheet.this.getTypeAt(index);
            return this;
        }

        public boolean isDate() {
            return this.type == Type.DATE;
        }

        public boolean isNumber() {
            return this.type == Type.NUMBER;
        }

        public boolean isString() {
            switch (this.type.ordinal()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }

        public Date getDate() {
            if (!this.isDate()) {
                throw new UnsupportedOperationException();
            }
            return CompactSheet.this.getDateAt(this.index);
        }

        public Number getNumber() {
            if (!this.isNumber()) {
                throw new UnsupportedOperationException();
            }
            return CompactSheet.this.getNumberAt(this.index);
        }

        public String getString() {
            switch (this.type.ordinal()) {
                case 3: {
                    return CompactSheet.this.getSharedStringAt(this.index);
                }
                case 4: {
                    return CompactSheet.this.getLocalStringAt(this.index);
                }
            }
            throw new UnsupportedOperationException();
        }

        public Cell.Type getType() {
            switch (this.type.ordinal()) {
                case 2: {
                    return Cell.Type.DATE;
                }
                case 1: {
                    return Cell.Type.NUMBER;
                }
                case 3: 
                case 4: {
                    return Cell.Type.STRING;
                }
            }
            throw new RuntimeException();
        }

        public Object getValue() {
            return CompactSheet.this.getValueAt(this.index);
        }

        public String toString() {
            return this.index + "";
        }
    }

    public static final class Builder {
        private final int rowCount;
        private final int columnCount;
        private final String name;
        private final ByteBuffer data;
        private final List<String> sharedStrings;
        private List<String> localStrings;

        private Builder(int rowCount, int columnCount, String name, List<String> sharedStrings) {
            this.rowCount = rowCount;
            this.columnCount = columnCount;
            this.name = Objects.requireNonNull(name);
            this.sharedStrings = Objects.requireNonNull(sharedStrings);
            this.data = ByteBuffer.allocate(rowCount * columnCount * 9);
            this.localStrings = null;
        }

        private int getIndex(int i, int j) {
            if (j >= this.columnCount) {
                throw new IndexOutOfBoundsException();
            }
            return (i * this.columnCount + j) * 9;
        }

        public Builder putNull(int i, int j) {
            int index = this.getIndex(i, j);
            this.data.put(index, (byte)Type.NULL.ordinal());
            return this;
        }

        public Builder putNumber(int i, int j, double number) {
            int index = this.getIndex(i, j);
            this.data.put(index, (byte)Type.NUMBER.ordinal());
            this.data.putDouble(index + 1, number);
            return this;
        }

        public Builder putDate(int i, int j, long date) {
            int index = this.getIndex(i, j);
            this.data.put(index, (byte)Type.DATE.ordinal());
            this.data.putLong(index + 1, date);
            return this;
        }

        public Builder putSharedString(int i, int j, int stringIndex) {
            int index = this.getIndex(i, j);
            this.data.put(index, (byte)Type.SHARED_STRING.ordinal());
            this.data.putInt(index + 1, stringIndex);
            return this;
        }

        public Builder putString(int i, int j, String string) {
            if (this.localStrings == null) {
                this.localStrings = new ArrayList<String>();
            }
            int index = this.getIndex(i, j);
            this.data.put(index, (byte)Type.LOCAL_STRING.ordinal());
            this.data.putInt(index + 1, this.localStrings.size());
            this.localStrings.add(string);
            return this;
        }

        public CompactSheet build() {
            return new CompactSheet(this.rowCount, this.columnCount, this.name, this.data, this.sharedStrings, this.localStrings != null ? this.localStrings : Collections.emptyList());
        }
    }
}

