/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import java.util.PrimitiveIterator;
import java.util.function.IntPredicate;
import org.checkerframework.checker.nullness.qual.Nullable;
import spreadsheet.xlsx.XlsxNumberingFormat;

public enum DefaultNumberingFormat implements XlsxNumberingFormat
{
    INSTANCE;

    public static final XlsxNumberingFormat.Factory FACTORY;

    @Override
    public boolean isExcelDateFormat(int numFmtId, String formatCode) {
        return DefaultNumberingFormat.isBuiltInExcelDateFormat(numFmtId) || DefaultNumberingFormat.isCustomExcelDateFormat(formatCode);
    }

    static boolean isBuiltInExcelDateFormat(int numFmtId) {
        switch (numFmtId) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    static boolean isCustomExcelDateFormat(@Nullable String formatCode) {
        if (formatCode != null) {
            PrimitiveIterator.OfInt iter = formatCode.chars().iterator();
            while (iter.hasNext()) {
                switch ((char)iter.nextInt()) {
                    case '\"': {
                        DefaultNumberingFormat.skipUntil(iter, o -> o == 34);
                        break;
                    }
                    case '[': {
                        DefaultNumberingFormat.skipUntil(iter, o -> o == 93);
                        break;
                    }
                    case '\\': {
                        if (!iter.hasNext()) break;
                        iter.nextInt();
                        break;
                    }
                    case 'd': 
                    case 'h': 
                    case 'm': 
                    case 's': 
                    case 'y': {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void skipUntil(PrimitiveIterator.OfInt iterator, IntPredicate predicate) {
        while (iterator.hasNext() && !predicate.test(iterator.nextInt())) {
        }
    }

    static {
        FACTORY = () -> INSTANCE;
    }
}

