/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArraySheet;
import ec.util.spreadsheet.helpers.CellRefHelper;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxDateSystem;
import spreadsheet.xlsx.XlsxSheetBuilder;
import spreadsheet.xlsx.internal.CompactSheet;
import spreadsheet.xlsx.internal.XlsxValueFactory;

public final class DefaultSheetBuilder
implements XlsxSheetBuilder {
    private final XlsxValueFactory valueFactory;
    private final List<String> sharedStrings;
    private final CellRefHelper refHelper;
    private ExtCallback callback;

    public static DefaultSheetBuilder of(XlsxDateSystem dateSystem, List<String> sharedStrings, boolean[] dateFormats) {
        return new DefaultSheetBuilder(new XlsxValueFactory(dateSystem, o -> dateFormats[o]), sharedStrings);
    }

    private DefaultSheetBuilder(XlsxValueFactory valueFactory, List<String> sharedStrings) {
        this.valueFactory = valueFactory;
        this.sharedStrings = sharedStrings;
        this.refHelper = new CellRefHelper();
        this.callback = NoOpCallback.INSTANCE;
    }

    @Override
    public XlsxSheetBuilder reset(String sheetName, String sheetBounds) {
        this.callback = this.newCallback(sheetName, sheetBounds);
        return this;
    }

    private ExtCallback newCallback(String sheetName, String sheetBounds) {
        int columnCount;
        int rowCount;
        if (this.refHelper.parseEnd((CharSequence)sheetBounds) && !CompactSheet.isOverflow(rowCount = this.refHelper.getRowIndex() + 1, columnCount = this.refHelper.getColumnIndex() + 1)) {
            return new CompactCallback(this.refHelper, CompactSheet.builder(rowCount, columnCount, sheetName, this.sharedStrings));
        }
        return new ArraySheetCallback(this.sharedStrings, this.refHelper, ArraySheet.builder().name(sheetName));
    }

    @Override
    public XlsxSheetBuilder put(String ref, CharSequence value, XlsxDataType dataType, int styleIndex) {
        this.valueFactory.parse(this.callback.moveTo(ref), value, dataType, styleIndex);
        return this;
    }

    @Override
    public Sheet build() {
        return this.callback.build();
    }

    @Override
    public void close() {
        this.callback = NoOpCallback.INSTANCE;
    }

    private static enum NoOpCallback implements ExtCallback
    {
        INSTANCE;


        @Override
        public ExtCallback moveTo(String ref) {
            return this;
        }

        @Override
        public Sheet build() {
            return ArraySheet.copyOf((String)"", (Object[][])new Object[0][0]);
        }

        @Override
        public void onNumber(double number) {
        }

        @Override
        public void onDate(long date) {
        }

        @Override
        public void onSharedString(int index) {
        }

        @Override
        public void onString(CharSequence string) {
        }

        @Override
        public void onNull() {
        }
    }

    private static interface ExtCallback
    extends XlsxValueFactory.Callback {
        public @NonNull ExtCallback moveTo(@NonNull String var1);

        public @NonNull Sheet build();
    }

    private static final class CompactCallback
    implements ExtCallback {
        private final CellRefHelper refHelper;
        private final CompactSheet.Builder sheet;
        private String ref;

        @Override
        public ExtCallback moveTo(String ref) {
            this.ref = ref;
            return this;
        }

        @Override
        public Sheet build() {
            return this.sheet.build();
        }

        @Override
        public void onNumber(double number) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.putNumber(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), number);
            }
        }

        @Override
        public void onDate(long date) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.putDate(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), date);
            }
        }

        @Override
        public void onSharedString(int index) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.putSharedString(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), index);
            }
        }

        @Override
        public void onString(CharSequence string) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.putString(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), string.toString());
            }
        }

        @Override
        public void onNull() {
        }

        @Generated
        public CompactCallback(CellRefHelper refHelper, CompactSheet.Builder sheet) {
            this.refHelper = refHelper;
            this.sheet = sheet;
        }
    }

    private static final class ArraySheetCallback
    implements ExtCallback {
        private final List<String> sharedStrings;
        private final CellRefHelper refHelper;
        private final ArraySheet.Builder sheet;
        private String ref;

        @Override
        public ExtCallback moveTo(String ref) {
            this.ref = ref;
            return this;
        }

        @Override
        public Sheet build() {
            return this.sheet.build();
        }

        @Override
        public void onNumber(double number) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.value(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), (Object)number);
            }
        }

        @Override
        public void onDate(long date) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.value(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), (Object)new Date(date));
            }
        }

        @Override
        public void onSharedString(int index) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.value(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), (Object)this.sharedStrings.get(index));
            }
        }

        @Override
        public void onString(CharSequence string) {
            if (this.refHelper.parse((CharSequence)this.ref)) {
                this.sheet.value(this.refHelper.getRowIndex(), this.refHelper.getColumnIndex(), (Object)string.toString());
            }
        }

        @Override
        public void onNull() {
        }

        @Generated
        public ArraySheetCallback(List<String> sharedStrings, CellRefHelper refHelper, ArraySheet.Builder sheet) {
            this.sharedStrings = sharedStrings;
            this.refHelper = refHelper;
            this.sheet = sheet;
        }
    }
}

