/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import ec.util.spreadsheet.Sheet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxDateSystem;
import spreadsheet.xlsx.XlsxSheetBuilder;
import spreadsheet.xlsx.internal.DefaultSheetBuilder;
import spreadsheet.xlsx.internal.XlsxValueFactory;

public final class MultiSheetBuilder
implements XlsxSheetBuilder {
    private static final int FIRST_BATCH_SIZE = 10;
    private static final int NEXT_BATCH_SIZE = 1000;
    private static final int QUEUE_MAX_SIZE = 10;
    private final DefaultSheetBuilder delegate;
    private final ExecutorService executor;
    private final CustomQueue queue;
    private Batch nextBatch;

    public static MultiSheetBuilder of(XlsxDateSystem dateSystem, List<String> sharedStrings, boolean[] dateFormats) {
        return new MultiSheetBuilder(DefaultSheetBuilder.of(dateSystem, sharedStrings, dateFormats));
    }

    private MultiSheetBuilder(DefaultSheetBuilder delegate) {
        this.delegate = delegate;
        this.executor = Executors.newSingleThreadExecutor();
        this.queue = new CustomQueue(10);
        this.nextBatch = new Batch(10);
    }

    @Override
    public XlsxSheetBuilder reset(String sheetName, String sheetBounds) {
        this.queue.waitForCompletion();
        this.delegate.reset(sheetName, sheetBounds);
        return this;
    }

    @Override
    public XlsxSheetBuilder put(String ref, CharSequence value, XlsxDataType dataType, int styleIndex) {
        if (this.nextBatch.isFull()) {
            if (this.queue.isFull()) {
                this.queue.waitForCompletion();
            }
            this.queue.add(this.executor.submit(this.nextBatch.asTask(this.delegate)));
            this.nextBatch = new Batch(1000);
        }
        this.nextBatch.put(ref, value, dataType, styleIndex);
        return this;
    }

    @Override
    public Sheet build() {
        this.queue.waitForCompletion();
        if (this.nextBatch.getSize() > 0) {
            this.nextBatch.process(this.delegate);
            this.nextBatch = new Batch(10);
        }
        return this.delegate.build();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(100L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            throw new IOException("While closing executor", ex);
        }
    }

    private static final class CustomQueue {
        private final int maxQueueSize;
        private final List<Future<?>> queue;

        CustomQueue(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            this.queue = new ArrayList(maxQueueSize);
        }

        boolean isFull() {
            return this.queue.size() >= this.maxQueueSize;
        }

        void waitForCompletion() {
            for (Future<?> o : this.queue) {
                try {
                    o.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.queue.clear();
        }

        private void add(Future<?> submit) {
            this.queue.add(submit);
        }
    }

    private static final class Batch {
        private final Object[][] values;
        private final int[] dataTypes;
        private final int[] styleIndexes;
        private int size;

        Batch(int maxSize) {
            this.values = new Object[maxSize][2];
            this.dataTypes = new int[maxSize];
            this.styleIndexes = new int[maxSize];
            this.size = 0;
        }

        void put(@NonNull String ref, @NonNull CharSequence value, @NonNull XlsxDataType dataType, int styleIndex) {
            Object[] row = this.values[this.size];
            row[0] = ref;
            row[1] = value;
            this.dataTypes[this.size] = dataType.ordinal();
            this.styleIndexes[this.size] = styleIndex;
            ++this.size;
        }

        int getSize() {
            return this.size;
        }

        boolean isFull() {
            return this.values.length == this.size;
        }

        void process(DefaultSheetBuilder delegate) {
            for (int i = 0; i < this.size; ++i) {
                delegate.put((String)this.values[i][0], (CharSequence)this.values[i][1], XlsxValueFactory.getDataTypeByOrdinal(this.dataTypes[i]), this.styleIndexes[i]);
            }
        }

        Runnable asTask(DefaultSheetBuilder delegate) {
            return () -> this.process(delegate);
        }
    }
}

