/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxEntryParser;
import spreadsheet.xlsx.internal.XlsxValueFactory;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;
import standalone_spreadsheet.nbbrd.io.xml.Sax;

public final class SaxEntryParser
implements XlsxEntryParser {
    @NonNull
    private final XMLReader reader;
    private static final IOSupplier VOID = IOSupplier.of(null);
    public static final XlsxEntryParser.Factory FACTORY = () -> new SaxEntryParser(Sax.createReader());

    public SaxEntryParser(XMLReader reader) {
        this.reader = SaxEntryParser.disableNamespaces(reader);
    }

    @Override
    public void visitWorkbook(InputStream stream, XlsxEntryParser.WorkbookVisitor visitor) throws IOException {
        this.visit(new WorkbookSaxEventHandler(visitor), stream);
    }

    @Override
    public void visitSharedStrings(InputStream stream, XlsxEntryParser.SharedStringsVisitor visitor) throws IOException {
        this.visit(new SharedStringsSaxEventHandler(visitor), stream);
    }

    @Override
    public void visitStyles(InputStream stream, XlsxEntryParser.StylesVisitor visitor) throws IOException {
        this.visit(new StylesSaxEventHandler(visitor), stream);
    }

    @Override
    public void visitSheet(InputStream stream, XlsxEntryParser.SheetVisitor visitor) throws IOException {
        this.visit(new SheetSaxEventHandler(visitor), stream);
    }

    @Override
    public void close() throws IOException {
    }

    private void visit(ContentHandler handler, InputStream stream) throws IOException {
        Sax.Parser.builder().factory(() -> this.reader).contentHandler(handler).after(VOID).build().parseStream(stream);
    }

    static boolean isChar(String input) {
        return input.length() == 1;
    }

    static boolean isEqualTo(String input, char c) {
        return input.length() == 1 && input.charAt(0) == c;
    }

    static XMLReader disableNamespaces(XMLReader reader) {
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException ex) {
            Logger.getLogger(SaxEntryParser.class.getName()).log(Level.FINE, null, ex);
        }
        return reader;
    }

    private static final class WorkbookSaxEventHandler
    extends DefaultHandler {
        private final XlsxEntryParser.WorkbookVisitor visitor;
        private static final String SHEET_TAG = "sheet";
        private static final String WORKBOOK_PROPERTIES_TAG = "workbookPr";
        private static final String DATE1904_ATTRIBUTE = "date1904";
        private static final String SHEET_TAB_ID_ATTRIBUTE = "r:id";
        private static final String SHEET_NAME_ATTRIBUTE = "name";

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "sheet": {
                    this.visitor.onSheet(attributes.getValue(SHEET_TAB_ID_ATTRIBUTE), attributes.getValue(SHEET_NAME_ATTRIBUTE));
                    break;
                }
                case "workbookPr": {
                    this.visitor.onDate1904(Boolean.parseBoolean(attributes.getValue(DATE1904_ATTRIBUTE)));
                }
            }
        }

        @Generated
        public WorkbookSaxEventHandler(XlsxEntryParser.WorkbookVisitor visitor) {
            this.visitor = visitor;
        }
    }

    private static final class SharedStringsSaxEventHandler
    extends DefaultHandler {
        private final XlsxEntryParser.SharedStringsVisitor visitor;
        private final SaxStringBuilder stringBuilder = new SaxStringBuilder();
        private static final String SHARED_STRING_ITEM_TAG = "si";
        private static final String TEXT_TAG = "t";

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "si": {
                    this.stringBuilder.clear();
                    break;
                }
                case "t": {
                    this.stringBuilder.enable();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "t": {
                    this.stringBuilder.disable();
                    break;
                }
                case "si": {
                    this.visitor.onSharedString(this.stringBuilder.build());
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stringBuilder.appendIfNeeded(ch, start, length);
        }

        @Generated
        public SharedStringsSaxEventHandler(XlsxEntryParser.SharedStringsVisitor visitor) {
            this.visitor = visitor;
        }
    }

    private static final class StylesSaxEventHandler
    extends DefaultHandler {
        private final XlsxEntryParser.StylesVisitor visitor;
        private boolean insideGroupTag = false;
        private static final String CELL_FORMAT_TAG = "xf";
        private static final String CELL_FORMATS_TAG = "cellXfs";
        private static final String NUMBER_FORMAT_TAG = "numFmt";
        private static final String NUMBER_FORMATS_TAG = "numFmts";
        private static final String NUMBER_FORMAT_ID_ATTRIBUTE = "numFmtId";
        private static final String NUMBER_FORMAT_CODE_ATTRIBUTE = "formatCode";

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "cellXfs": {
                    this.insideGroupTag = true;
                    break;
                }
                case "xf": {
                    if (!this.insideGroupTag) break;
                    try {
                        this.visitor.onCellFormat(Integer.parseInt(attributes.getValue(NUMBER_FORMAT_ID_ATTRIBUTE)));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
                case "numFmts": {
                    this.insideGroupTag = true;
                    break;
                }
                case "numFmt": {
                    if (!this.insideGroupTag) break;
                    try {
                        this.visitor.onNumberFormat(Integer.parseInt(attributes.getValue(NUMBER_FORMAT_ID_ATTRIBUTE)), attributes.getValue(NUMBER_FORMAT_CODE_ATTRIBUTE));
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals(CELL_FORMATS_TAG) || qName.equals(NUMBER_FORMATS_TAG)) {
                this.insideGroupTag = false;
            }
        }

        @Generated
        public StylesSaxEventHandler(XlsxEntryParser.StylesVisitor visitor) {
            this.visitor = visitor;
        }
    }

    private static final class SheetSaxEventHandler
    extends DefaultHandler {
        private final XlsxEntryParser.SheetVisitor visitor;
        private final SaxStringBuilder stringBuilder = new SaxStringBuilder();
        private int level = 0;
        private String sheetBounds = null;
        private String ref = null;
        private String rawDataType = null;
        private String rawStyleIndex = null;
        private static final char CELL_TAG = 'c';
        private static final char REFERENCE_ATTRIBUTE = 'r';
        private static final char STYLE_INDEX_ATTRIBUTE = 's';
        private static final char CELL_DATA_TYPE_ATTRIBUTE = 't';
        private static final char CELL_VALUE_TAG = 'v';
        private static final String SHEET_DIMENSIONS_TAG = "dimension";
        private static final String SHEET_BOUNDS_ATTRIBUTE = "ref";
        private static final String SHEET_DATA_TAG = "sheetData";
        private static final String INLINE_STRING_TAG = "is";
        private static final char BOOLEAN_TYPE = 'b';
        private static final char NUMBER_TYPE = 'n';
        private static final char ERROR_TYPE = 'e';
        private static final char SHARED_STRING_TYPE = 's';
        private static final String STRING_TYPE = "str";
        private static final String INLINE_STRING_TYPE = "inlineStr";
        private static final char DATE_TYPE = 'd';

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.level) {
                case 1: {
                    switch (name) {
                        case "dimension": {
                            this.sheetBounds = attributes.getValue(SHEET_BOUNDS_ATTRIBUTE);
                            break;
                        }
                        case "sheetData": {
                            this.visitor.onSheetData(this.sheetBounds);
                        }
                    }
                    break;
                }
                case 3: {
                    if (!SaxEntryParser.isEqualTo(name, 'c')) break;
                    this.parseCellAttributes(attributes);
                    break;
                }
                case 4: {
                    if (SaxEntryParser.isChar(name)) {
                        if (name.charAt(0) != 'v') break;
                        this.stringBuilder.enable().clear();
                        break;
                    }
                    if (!name.equals(INLINE_STRING_TAG)) break;
                    this.stringBuilder.enable().clear();
                }
            }
            ++this.level;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            --this.level;
            switch (this.level) {
                case 4: {
                    if (SaxEntryParser.isChar(name)) {
                        if (name.charAt(0) != 'v') break;
                        this.pushCellValue();
                        break;
                    }
                    if (!name.equals(INLINE_STRING_TAG)) break;
                    this.pushCellValue();
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stringBuilder.appendIfNeeded(ch, start, length);
        }

        private void pushCellValue() {
            if (this.ref != null) {
                XlsxDataType dataType = SheetSaxEventHandler.parseDataType(this.rawDataType);
                int styleIndex = XlsxValueFactory.isStyleRequired(dataType) ? XlsxValueFactory.parseStyleIndex(this.rawStyleIndex) : Integer.MAX_VALUE;
                this.visitor.onCell(this.ref, this.stringBuilder.disable().build(), dataType, styleIndex);
            }
        }

        private void parseCellAttributes(Attributes attributes) {
            this.ref = null;
            this.rawDataType = null;
            this.rawStyleIndex = null;
            block5: for (int i = 0; i < attributes.getLength(); ++i) {
                String attribute = attributes.getLocalName(i);
                if (!SaxEntryParser.isChar(attribute)) continue;
                switch (attribute.charAt(0)) {
                    case 'r': {
                        this.ref = attributes.getValue(i);
                        continue block5;
                    }
                    case 't': {
                        this.rawDataType = attributes.getValue(i);
                        continue block5;
                    }
                    case 's': {
                        this.rawStyleIndex = attributes.getValue(i);
                    }
                }
            }
        }

        private static @org.checkerframework.checker.nullness.qual.NonNull XlsxDataType parseDataType(@Nullable String rawDataType) {
            if (rawDataType == null) {
                return XlsxDataType.UNDEFINED;
            }
            if (SaxEntryParser.isChar(rawDataType)) {
                switch (rawDataType.charAt(0)) {
                    case 'n': {
                        return XlsxDataType.NUMBER;
                    }
                    case 's': {
                        return XlsxDataType.SHARED_STRING;
                    }
                    case 'd': {
                        return XlsxDataType.DATE;
                    }
                    case 'b': {
                        return XlsxDataType.BOOLEAN;
                    }
                    case 'e': {
                        return XlsxDataType.ERROR;
                    }
                }
                return XlsxDataType.UNKNOWN;
            }
            switch (rawDataType) {
                case "str": {
                    return XlsxDataType.STRING;
                }
                case "inlineStr": {
                    return XlsxDataType.INLINE_STRING;
                }
            }
            return XlsxDataType.UNKNOWN;
        }

        @Generated
        public SheetSaxEventHandler(XlsxEntryParser.SheetVisitor visitor) {
            this.visitor = visitor;
        }
    }

    private static final class SaxStringBuilder {
        private boolean enabled = false;
        private char[] buffer = new char[64];
        private int bufferLength = 0;

        private SaxStringBuilder() {
        }

        public SaxStringBuilder clear() {
            this.bufferLength = 0;
            return this;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public SaxStringBuilder enable() {
            this.enabled = true;
            return this;
        }

        public SaxStringBuilder disable() {
            this.enabled = false;
            return this;
        }

        public String build() {
            return new String(this.buffer, 0, this.bufferLength);
        }

        public SaxStringBuilder appendIfNeeded(char[] ch, int start, int length) {
            if (this.isEnabled()) {
                int expectedLength = this.bufferLength + length;
                if (expectedLength > this.buffer.length) {
                    this.buffer = Arrays.copyOf(this.buffer, expectedLength);
                }
                System.arraycopy(ch, start, this.buffer, this.bufferLength, length);
                this.bufferLength = expectedLength;
            }
            return this;
        }
    }
}

