/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import lombok.Generated;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxDateSystem;
import spreadsheet.xlsx.XlsxEntryParser;
import spreadsheet.xlsx.XlsxNumberingFormat;
import spreadsheet.xlsx.XlsxPackage;
import spreadsheet.xlsx.XlsxReader;
import spreadsheet.xlsx.XlsxSheetBuilder;
import spreadsheet.xlsx.internal.DefaultSheetBuilder;
import spreadsheet.xlsx.internal.SaxEntryParser;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;
import standalone_spreadsheet.nbbrd.io.xml.Sax;

public final class XlsxBook
extends Book {
    private final XlsxPackage pkg;
    private final List<SheetMeta> sheets;
    private final Supplier<XlsxDateSystem> dateSystem;
    private final IOSupplier<List<String>> sharedStrings;
    private final IOSupplier<boolean[]> dateFormats;
    private final XlsxEntryParser mainEntryParser;
    private final XlsxSheetBuilder.Factory mainSheetBuilderFactory;
    private XlsxSheetBuilder mainSheetBuilder = null;

    public static @NonNull XlsxBook create(@NonNull XlsxPackage pkg, @NonNull XlsxReader reader) throws IOException {
        XlsxEntryParser mainEntryParser = null;
        try {
            mainEntryParser = reader.getEntryParser().create();
            WorkbookData data = XlsxBook.parseWorkbook(pkg::getWorkbook, mainEntryParser);
            return new XlsxBook(pkg, data.sheets, XlsxBook.dateSystemOf(reader.getDateSystem(), data.date1904), XlsxBook.sharedStringsOf(pkg, mainEntryParser), XlsxBook.dateFormatsOf(pkg, mainEntryParser, reader.getNumberingFormat()), mainEntryParser, reader.getSheetBuilder());
        }
        catch (IOException ex) {
            XlsxBook.closeAll(ex, mainEntryParser);
            throw ex;
        }
    }

    private static Supplier<XlsxDateSystem> dateSystemOf(XlsxDateSystem.Factory dateSystem, boolean date1904) {
        return () -> dateSystem.of(date1904);
    }

    private static IOSupplier<List<String>> sharedStringsOf(XlsxPackage pkg, XlsxEntryParser entryParser) {
        return () -> XlsxBook.parseSharedStrings(pkg::getSharedStrings, entryParser);
    }

    private static IOSupplier<boolean[]> dateFormatsOf(XlsxPackage pkg, XlsxEntryParser entryParser, XlsxNumberingFormat.Factory numberingFormat) {
        return () -> XlsxBook.parseStyles(numberingFormat.of(), pkg::getStyles, entryParser);
    }

    public void close() throws IOException {
        XlsxBook.closeAll(null, this.pkg, this.mainEntryParser, this.mainSheetBuilder);
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public @NonNull Sheet getSheet(int index) throws IOException {
        if (this.mainSheetBuilder == null) {
            this.mainSheetBuilder = this.mainSheetBuilderFactory.create(this.dateSystem.get(), this.sharedStrings.getWithIO(), this.dateFormats.getWithIO());
        }
        return this.getSheet(index, this.mainSheetBuilder, this.mainEntryParser);
    }

    public @NonNull String getSheetName(@NonNegative int index) {
        return this.sheets.get(index).getName();
    }

    public void parallelForEach(@NonNull ObjIntConsumer<? super Sheet> action) throws IOException {
        XlsxDateSystem x = this.dateSystem.get();
        List<String> y = this.sharedStrings.getWithIO();
        boolean[] z = this.dateFormats.getWithIO();
        try {
            IntStream.range(0, this.getSheetCount2()).parallel().forEach(index -> {
                try {
                    Sheet sheet = this.getSheet(index, DefaultSheetBuilder.of(x, y, z), new SaxEntryParser(Sax.createReader()));
                    action.accept(sheet, index);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }

    private Sheet getSheet(int index, XlsxSheetBuilder sheetBuilder, XlsxEntryParser entryParser) throws IOException {
        SheetMeta meta = this.sheets.get(index);
        return XlsxBook.parseSheet(meta.name, sheetBuilder, () -> this.pkg.getSheet(meta.relationId), entryParser);
    }

    static void closeAll(IOException initial, Closeable ... closeables) throws IOException {
        for (Closeable o : closeables) {
            if (o == null) continue;
            try {
                o.close();
            }
            catch (IOException ex) {
                if (initial == null) {
                    initial = ex;
                    continue;
                }
                initial.addSuppressed(ex);
            }
        }
        if (initial != null) {
            throw initial;
        }
    }

    static WorkbookData parseWorkbook(IOSupplier<? extends InputStream> byteSource, XlsxEntryParser parser) throws IOException {
        WorkbookVisitorImpl result = new WorkbookVisitorImpl();
        try (InputStream stream = byteSource.getWithIO();){
            parser.visitWorkbook(stream, result);
        }
        return result.build();
    }

    static List<String> parseSharedStrings(IOSupplier<? extends InputStream> byteSource, XlsxEntryParser parser) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (InputStream stream = byteSource.getWithIO();){
            parser.visitSharedStrings(stream, o -> result.add(Objects.requireNonNull(o)));
        }
        return result;
    }

    static boolean[] parseStyles(XlsxNumberingFormat dateFormat, IOSupplier<? extends InputStream> byteSource, XlsxEntryParser parser) throws IOException {
        StylesVisitorImpl result = new StylesVisitorImpl(dateFormat);
        try (InputStream stream = byteSource.getWithIO();){
            parser.visitStyles(stream, result);
        }
        return result.build();
    }

    static Sheet parseSheet(String name, XlsxSheetBuilder sheetBuilder, IOSupplier<? extends InputStream> byteSource, XlsxEntryParser parser) throws IOException {
        SheetVisitorImpl result = new SheetVisitorImpl(name, sheetBuilder);
        try (InputStream stream = byteSource.getWithIO();){
            parser.visitSheet(stream, result);
        }
        return result.build();
    }

    @Generated
    public XlsxBook(XlsxPackage pkg, List<SheetMeta> sheets, Supplier<XlsxDateSystem> dateSystem, IOSupplier<List<String>> sharedStrings, IOSupplier<boolean[]> dateFormats, XlsxEntryParser mainEntryParser, XlsxSheetBuilder.Factory mainSheetBuilderFactory) {
        this.pkg = pkg;
        this.sheets = sheets;
        this.dateSystem = dateSystem;
        this.sharedStrings = sharedStrings;
        this.dateFormats = dateFormats;
        this.mainEntryParser = mainEntryParser;
        this.mainSheetBuilderFactory = mainSheetBuilderFactory;
    }

    static final class WorkbookData {
        private final List<SheetMeta> sheets;
        private final boolean date1904;

        @Generated
        public WorkbookData(List<SheetMeta> sheets, boolean date1904) {
            this.sheets = sheets;
            this.date1904 = date1904;
        }

        @Generated
        public List<SheetMeta> getSheets() {
            return this.sheets;
        }

        @Generated
        public boolean isDate1904() {
            return this.date1904;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkbookData)) {
                return false;
            }
            WorkbookData other = (WorkbookData)o;
            if (this.isDate1904() != other.isDate1904()) {
                return false;
            }
            List<SheetMeta> this$sheets = this.getSheets();
            List<SheetMeta> other$sheets = other.getSheets();
            return !(this$sheets == null ? other$sheets != null : !((Object)this$sheets).equals(other$sheets));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDate1904() ? 79 : 97);
            List<SheetMeta> $sheets = this.getSheets();
            result = result * 59 + ($sheets == null ? 43 : ((Object)$sheets).hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "XlsxBook.WorkbookData(sheets=" + this.getSheets() + ", date1904=" + this.isDate1904() + ")";
        }
    }

    static final class SheetMeta {
        private final @NonNull String relationId;
        private final @NonNull String name;

        @Generated
        public SheetMeta(@NonNull String relationId, @NonNull String name) {
            if (relationId == null) {
                throw new NullPointerException("relationId is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.relationId = relationId;
            this.name = name;
        }

        @Generated
        public @NonNull String getRelationId() {
            return this.relationId;
        }

        @Generated
        public @NonNull String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SheetMeta)) {
                return false;
            }
            SheetMeta other = (SheetMeta)o;
            String this$relationId = this.getRelationId();
            String other$relationId = other.getRelationId();
            if (this$relationId == null ? other$relationId != null : !this$relationId.equals(other$relationId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $relationId = this.getRelationId();
            result = result * 59 + ($relationId == null ? 43 : $relationId.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "XlsxBook.SheetMeta(relationId=" + this.getRelationId() + ", name=" + this.getName() + ")";
        }
    }

    private static final class WorkbookVisitorImpl
    implements XlsxEntryParser.WorkbookVisitor {
        private final List<SheetMeta> sheets = new ArrayList<SheetMeta>();
        private boolean date1904 = false;

        private WorkbookVisitorImpl() {
        }

        @Override
        public void onSheet(String relationId, String name) {
            this.sheets.add(new SheetMeta(relationId, name));
        }

        @Override
        public void onDate1904(boolean date1904) {
            this.date1904 = date1904;
        }

        WorkbookData build() {
            return new WorkbookData(this.sheets, this.date1904);
        }
    }

    private static final class StylesVisitorImpl
    implements XlsxEntryParser.StylesVisitor {
        private final XlsxNumberingFormat dateFormat;
        private final List<Integer> orderedListOfIds = new ArrayList<Integer>();
        private final Map<Integer, String> numberFormats = new HashMap<Integer, String>();

        StylesVisitorImpl(XlsxNumberingFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void onNumberFormat(int formatId, String formatCode) {
            this.numberFormats.put(formatId, formatCode);
        }

        @Override
        public void onCellFormat(int formatId) {
            this.orderedListOfIds.add(formatId);
        }

        public boolean[] build() {
            boolean[] result = new boolean[this.orderedListOfIds.size()];
            for (int i = 0; i < result.length; ++i) {
                int numFmtId = this.orderedListOfIds.get(i);
                result[i] = this.dateFormat.isExcelDateFormat(numFmtId, this.numberFormats.getOrDefault(numFmtId, null));
            }
            return result;
        }
    }

    private static final class SheetVisitorImpl
    implements XlsxEntryParser.SheetVisitor {
        private final String sheetName;
        private final XlsxSheetBuilder sheetBuilder;
        private boolean inData;

        SheetVisitorImpl(String sheetName, XlsxSheetBuilder sheetBuilder) {
            this.sheetName = sheetName;
            this.sheetBuilder = sheetBuilder;
            this.inData = false;
        }

        @Override
        public void onSheetData(String sheetBounds) {
            if (this.inData) {
                throw new IllegalStateException();
            }
            this.sheetBuilder.reset(this.sheetName, sheetBounds);
            this.inData = true;
        }

        @Override
        public void onCell(String ref, CharSequence value, XlsxDataType dataType, int styleIndex) {
            if (!this.inData) {
                throw new IllegalStateException();
            }
            this.sheetBuilder.put(ref, value, dataType, styleIndex);
        }

        public Sheet build() {
            return this.sheetBuilder.build();
        }
    }
}

