/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.IntPredicate;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import spreadsheet.xlsx.XlsxDataType;
import spreadsheet.xlsx.XlsxDateSystem;

final class XlsxValueFactory {
    private final ParserWithStyle numberOrDate;
    private final Parser sharedString;
    private final Parser date;
    public static final int NULL_STYLE_INDEX = Integer.MAX_VALUE;
    public static final int INVALID_STYLE_INDEX = Integer.MIN_VALUE;
    private static final XlsxDataType[] DTYPES = XlsxDataType.values();

    XlsxValueFactory(XlsxDateSystem dateSystem, IntPredicate dateFormats) {
        this.numberOrDate = new NumberOrDateParser(dateSystem, dateFormats, NumberOrDateParser.newCalendar());
        this.sharedString = new SharedStringParser();
        this.date = new DateParser();
    }

    public void parse(Callback callback, CharSequence value, XlsxDataType dataType, int styleIndex) {
        switch (dataType) {
            case UNDEFINED: {
                this.numberOrDate.parse(callback, value.toString(), styleIndex);
                break;
            }
            case NUMBER: {
                this.numberOrDate.parse(callback, value.toString(), styleIndex);
                break;
            }
            case SHARED_STRING: {
                this.sharedString.parse(callback, value.toString());
                break;
            }
            case DATE: {
                this.date.parse(callback, value.toString());
                break;
            }
            case STRING: {
                callback.onString(value.toString());
                break;
            }
            case INLINE_STRING: {
                callback.onString(value.toString());
                break;
            }
            default: {
                callback.onNull();
            }
        }
    }

    public static int parseStyleIndex(@Nullable String rawStyleIndex) {
        if (rawStyleIndex != null) {
            try {
                return Integer.parseInt(rawStyleIndex);
            }
            catch (NumberFormatException ex) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isStyleRequired(@NonNull XlsxDataType dataType) {
        switch (dataType) {
            case UNDEFINED: 
            case NUMBER: {
                return true;
            }
        }
        return false;
    }

    public static XlsxDataType getDataTypeByOrdinal(int ordinal) {
        return DTYPES[ordinal];
    }

    static final class NumberOrDateParser
    implements ParserWithStyle {
        private final XlsxDateSystem dateSystem;
        private final IntPredicate dateFormats;
        private final Calendar calendar;

        static GregorianCalendar newCalendar() {
            return new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        }

        private boolean isDate(double number, int styleIndex) throws IndexOutOfBoundsException {
            return this.dateFormats.test(styleIndex) && this.dateSystem.isValidExcelDate(number);
        }

        @Override
        public void parse(Callback callback, CharSequence rawValue, int styleIndex) {
            try {
                double number = Double.parseDouble(rawValue.toString());
                switch (styleIndex) {
                    case 0x7FFFFFFF: {
                        callback.onNumber(number);
                        break;
                    }
                    case -2147483648: {
                        callback.onNull();
                        break;
                    }
                    default: {
                        if (this.isDate(number, styleIndex)) {
                            callback.onDate(this.dateSystem.getJavaDateInMillis(this.calendar, number));
                            break;
                        }
                        callback.onNumber(number);
                        break;
                    }
                }
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                callback.onNull();
            }
        }

        @Generated
        public NumberOrDateParser(XlsxDateSystem dateSystem, IntPredicate dateFormats, Calendar calendar) {
            this.dateSystem = dateSystem;
            this.dateFormats = dateFormats;
            this.calendar = calendar;
        }
    }

    static interface ParserWithStyle {
        public void parse(@NonNull Callback var1, @NonNull CharSequence var2, int var3);
    }

    static final class SharedStringParser
    implements Parser {
        SharedStringParser() {
        }

        @Override
        public void parse(Callback callback, CharSequence rawValue) {
            try {
                callback.onSharedString(Integer.parseInt(rawValue.toString()));
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                callback.onNull();
            }
        }
    }

    static interface Parser {
        public void parse(@NonNull Callback var1, @NonNull CharSequence var2);
    }

    static final class DateParser
    implements Parser {
        private final ZoneId zoneId = ZoneId.systemDefault();

        DateParser() {
        }

        @Override
        public void parse(Callback callback, CharSequence rawValue) {
            try {
                callback.onDate(this.parseLocalDateTime(rawValue));
            }
            catch (DateTimeParseException dateTimeEx) {
                try {
                    callback.onDate(this.parseLocalDate(rawValue));
                }
                catch (DateTimeParseException dateEx) {
                    callback.onNull();
                }
            }
        }

        private long parseLocalDateTime(CharSequence rawValue) {
            return DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse(rawValue, LocalDateTime::from).atZone(this.zoneId).toInstant().toEpochMilli();
        }

        private long parseLocalDate(CharSequence rawValue) {
            return DateTimeFormatter.ISO_LOCAL_DATE.parse(rawValue, LocalDate::from).atStartOfDay(this.zoneId).toInstant().toEpochMilli();
        }
    }

    static interface Callback {
        public void onNumber(double var1);

        public void onDate(long var1);

        public void onSharedString(int var1);

        public void onString(CharSequence var1);

        public void onNull();
    }
}

