/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.time.LocalDate;
import java.util.Objects;
import standalone_spreadsheet.com.github.miachm.sods.GroupCell;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotation;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.TableField;

class Cell
extends TableField {
    private Object value;
    private String formula;
    private Style style = Style.default_style;
    private GroupCell group;
    private OfficeAnnotation annotation;

    Cell() {
    }

    GroupCell getGroup() {
        return this.group;
    }

    void setGroup(GroupCell group) {
        this.group = group;
    }

    Style getStyle() {
        if (this.style.isDefault()) {
            this.style = new Style();
        }
        return this.style;
    }

    Style getStyleCopy() {
        try {
            return (Style)this.style.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e.toString());
        }
    }

    void setStyle(Style style) {
        if (style == null) {
            throw new IllegalArgumentException("Style can not be null");
        }
        try {
            this.style = (Style)style.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Style is not cloneable");
        }
    }

    void clear() {
        this.value = null;
        this.formula = null;
        this.style = Style.default_style;
        this.annotation = null;
    }

    String getFormula() {
        return this.formula;
    }

    Object getValue() {
        return this.value;
    }

    void setValue(Object value) {
        this.value = value;
        if (value instanceof LocalDate) {
            if (this.style.getDataStyle() == null) {
                this.style.setDataStyle("YYYY-MM-DD");
            }
        } else if ("YYYY-MM-DD".equals(this.style.getDataStyle())) {
            this.style.setDataStyle(null);
        }
    }

    public void setFormula(String formula) {
        if (formula != null && formula.startsWith("of:")) {
            formula = this.convertFormula(formula);
        }
        this.formula = formula;
    }

    private String convertFormula(String formula) {
        formula = formula.trim();
        formula = formula.substring("of:".length());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < formula.length(); ++i) {
            char character = formula.charAt(i);
            if (character == '[' || character == ']' || character == '.') continue;
            result.append(character);
        }
        return result.toString();
    }

    public OfficeAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(OfficeAnnotation annotation) {
        this.annotation = annotation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        GroupCell groupCell = this.getGroup();
        if (groupCell != null) {
            if (!groupCell.equals(cell.getGroup())) {
                return false;
            }
            if (groupCell.getCell() != this) {
                return groupCell.getCell().equals(cell.getGroup().getCell());
            }
        }
        if (!Objects.equals(this.value, cell.value)) {
            return false;
        }
        if (!Objects.equals(this.formula, cell.formula)) {
            return false;
        }
        if (!Objects.equals(this.annotation, cell.annotation)) {
            return false;
        }
        if (!Objects.equals(this.num_repeated, cell.num_repeated)) {
            return false;
        }
        return this.style.equals(cell.getStyle());
    }

    public int hashCode() {
        GroupCell groupCell = this.getGroup();
        if (groupCell != null && groupCell.getCell() != this) {
            return groupCell.getCell().hashCode();
        }
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.formula != null ? this.formula.hashCode() : 0);
        result = 31 * result + this.style.hashCode();
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + this.annotation.hashCode();
        return result;
    }

    public String toString() {
        if (this.getGroup() == null || this.getGroup().getCell() == this) {
            return "Cell{value=" + this.value + ", formula='" + this.formula + '\'' + ", style=" + this.style + ", num_repeated=" + this.num_repeated + '}';
        }
        return this.getGroup().getCell().toString();
    }
}

