/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.Objects;
import standalone_spreadsheet.com.github.miachm.sods.Style;

public class ConditionalFormat {
    private Style apply;
    private String rawCondition;

    ConditionalFormat(Style apply, String rawCondition) {
        this.apply = apply;
        this.rawCondition = rawCondition;
    }

    public Style getStyleApplied() {
        return this.apply;
    }

    String getRawCondition() {
        return this.rawCondition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalFormat that = (ConditionalFormat)o;
        return this.apply.equals(that.apply) && this.rawCondition.equals(that.rawCondition);
    }

    public int hashCode() {
        return Objects.hash(this.apply, this.rawCondition);
    }

    public static ConditionalFormat conditionWhenValueIsGreater(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()>" + value);
    }

    public static ConditionalFormat conditionWhenValueIsLower(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()<" + value);
    }

    public static ConditionalFormat conditionWhenValueIsEqual(Style apply, double value) {
        return new ConditionalFormat(apply, "cell-content()=" + value);
    }

    public static ConditionalFormat conditionWhenValueIsEqual(Style apply, String value) {
        return new ConditionalFormat(apply, "cell-content()=\"" + value + "\"");
    }

    public static ConditionalFormat conditionWhenValueIsBetween(Style apply, double init, double end) {
        if (init >= end) {
            throw new IllegalArgumentException("Value init " + init + " is greater than end " + end + " argument");
        }
        return new ConditionalFormat(apply, "cell-content-is-between(" + init + "," + end + ")");
    }
}

