/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import standalone_spreadsheet.com.github.miachm.sods.Color;
import standalone_spreadsheet.com.github.miachm.sods.ColumnStyle;
import standalone_spreadsheet.com.github.miachm.sods.ConditionalFormat;
import standalone_spreadsheet.com.github.miachm.sods.NotAnOdsException;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotation;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotationBuilder;
import standalone_spreadsheet.com.github.miachm.sods.OfficeValueType;
import standalone_spreadsheet.com.github.miachm.sods.OperationNotSupportedException;
import standalone_spreadsheet.com.github.miachm.sods.Pair;
import standalone_spreadsheet.com.github.miachm.sods.Range;
import standalone_spreadsheet.com.github.miachm.sods.RowStyle;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;
import standalone_spreadsheet.com.github.miachm.sods.SpreadSheet;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.TableStyle;
import standalone_spreadsheet.com.github.miachm.sods.Uncompressor;
import standalone_spreadsheet.com.github.miachm.sods.Vector;
import standalone_spreadsheet.com.github.miachm.sods.XmlReader;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderEventImpl;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstanceEventImpl;

class OdsReader {
    private static final String CORRECT_MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";
    private static final String MANIFEST_PATH = "META-INF/manifest.xml";
    private static final Locale defaultLocal = Locale.US;
    private static final int BUGGED_COUNT = 10000;
    private Uncompressor uncompressor;
    private XmlReader reader = new XmlReaderEventImpl();
    private SpreadSheet spread;
    private Map<String, Style> styles = new HashMap<String, Style>();
    private Map<Integer, Style> rows_styles = new HashMap<Integer, Style>();
    private Map<Integer, Style> columns_styles = new HashMap<Integer, Style>();
    private Map<String, ColumnStyle> styleColumn = new HashMap<String, ColumnStyle>();
    private Map<String, RowStyle> styleRow = new HashMap<String, RowStyle>();
    private Map<String, TableStyle> styleTable = new HashMap<String, TableStyle>();
    private Set<Pair<Vector, Vector>> groupCells = new HashSet<Pair<Vector, Vector>>();

    private OdsReader(InputStream in, SpreadSheet spread) {
        this.spread = spread;
        this.styles.put("Default", new Style());
        this.uncompressor = new Uncompressor(in);
    }

    static void load(InputStream in, SpreadSheet spread) throws IOException {
        OdsReader reader = new OdsReader(in, spread);
        reader.load();
    }

    private void load() throws IOException {
        boolean mimetypeChecked = false;
        String entry = this.uncompressor.nextFile();
        while (entry != null) {
            if (entry.endsWith(".xml")) {
                this.processContent();
            } else if (entry.equals("mimetype")) {
                this.checkMimeType();
                mimetypeChecked = true;
            }
            entry = this.uncompressor.nextFile();
        }
        this.uncompressor.close();
        this.spread.trimSheets();
        if (!mimetypeChecked) {
            throw new NotAnOdsException("This file doesn't contain a mimetype");
        }
    }

    private void checkMimeType() throws IOException {
        byte[] buff = new byte[CORRECT_MIMETYPE.getBytes().length];
        this.uncompressor.getInputStream().read(buff);
        String mimetype = new String(buff);
        if (!mimetype.equals(CORRECT_MIMETYPE)) {
            throw new NotAnOdsException("This file doesn't look like an ODS file. Mimetype: " + mimetype);
        }
    }

    private void processContent() throws IOException {
        InputStream in = this.uncompressor.getInputStream();
        XmlReaderInstanceEventImpl instance = this.reader.load(in);
        if (instance == null) {
            return;
        }
        XmlReaderInstance styles = instance.nextElement("office:automatic-styles", "office:styles");
        this.iterateStyleEntries(styles);
        XmlReaderInstance content = instance.nextElement("office:body");
        this.iterateFilesEntries(content);
        this.reader.close();
    }

    private void iterateStyleEntries(XmlReaderInstance reader) {
        if (reader == null) {
            return;
        }
        while (reader.hasNext()) {
            Object style;
            XmlReaderInstance instance = reader.nextElement("style:style");
            if (instance == null) {
                return;
            }
            String name = instance.getAttribValue("style:name");
            String family = instance.getAttribValue("style:family");
            if (name == null || family == null) continue;
            if (family.equals("table-cell")) {
                style = this.readCellStyleEntry(instance, name);
                this.styles.put(name, (Style)style);
                continue;
            }
            if (family.equals("table-column")) {
                style = this.readColumnStyleEntry(instance);
                this.styleColumn.put(name, (ColumnStyle)style);
                continue;
            }
            if (family.equals("table-row")) {
                style = this.readRowStyleEntry(instance);
                this.styleRow.put(name, (RowStyle)style);
                continue;
            }
            if (!family.equals("table")) continue;
            style = this.readTableStyleEntry(instance);
            this.styleTable.put(name, (TableStyle)style);
        }
    }

    private Style readCellStyleEntry(XmlReaderInstance reader, String name) {
        Style style = this.styles.get(name);
        if (style == null) {
            style = new Style();
        }
        while (reader.hasNext()) {
            String align;
            XmlReaderInstance instance = reader.nextElement("style:text-properties", "style:table-cell-properties", "style:paragraph-properties", "style:map");
            if (instance == null) {
                return style;
            }
            if (instance.getTag().equals("style:text-properties")) {
                String fontsize;
                String fontcolor;
                String underline;
                String italic;
                String bold = instance.getAttribValue("fo:font-weight");
                if (bold != null) {
                    style.setBold(bold.equals("bold"));
                }
                if ((italic = instance.getAttribValue("fo:font-style")) != null) {
                    style.setItalic(italic.equals("italic"));
                }
                if ((underline = instance.getAttribValue("style:text-underline-style")) != null) {
                    style.setUnderline(underline.equals("solid"));
                }
                if ((fontcolor = instance.getAttribValue("fo:color")) != null && !fontcolor.equals("transparent")) {
                    try {
                        style.setFontColor(new Color(fontcolor));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(e.getMessage());
                    }
                }
                if ((fontsize = instance.getAttribValue("fo:font-size")) != null) {
                    if (fontsize.endsWith("pt")) {
                        try {
                            int index = fontsize.lastIndexOf("pt");
                            int fontSize = (int)Math.round(Double.parseDouble(fontsize.substring(0, index)));
                            style.setFontSize(fontSize);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error, invalid font size " + fontsize);
                        }
                    } else {
                        throw new OperationNotSupportedException("Error, font size is not measured in PT. Skipping...");
                    }
                }
            }
            if (instance.getTag().equals("style:table-cell-properties")) {
                String verticalAlign;
                String backgroundColor = instance.getAttribValue("fo:background-color");
                if (backgroundColor != null && !backgroundColor.equals("transparent")) {
                    try {
                        style.setBackgroundColor(new Color(backgroundColor));
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println(e.getMessage());
                    }
                }
                if ((verticalAlign = instance.getAttribValue("style:vertical-align")) != null) {
                    Style.VERTICAL_TEXT_ALIGMENT pos = null;
                    if (verticalAlign.equalsIgnoreCase("middle")) {
                        pos = Style.VERTICAL_TEXT_ALIGMENT.Middle;
                    } else if (verticalAlign.equalsIgnoreCase("top")) {
                        pos = Style.VERTICAL_TEXT_ALIGMENT.Top;
                    } else if (verticalAlign.equalsIgnoreCase("bottom")) {
                        pos = Style.VERTICAL_TEXT_ALIGMENT.Bottom;
                    }
                    style.setVerticalTextAligment(pos);
                }
            }
            if (instance.getTag().equals("style:paragraph-properties") && (align = instance.getAttribValue("fo:text-align")) != null) {
                Style.TEXT_ALIGMENT pos = null;
                if (align.equals("center")) {
                    pos = Style.TEXT_ALIGMENT.Center;
                } else if (align.equals("end")) {
                    pos = Style.TEXT_ALIGMENT.Right;
                } else if (align.equals("start")) {
                    pos = Style.TEXT_ALIGMENT.Left;
                }
                style.setTextAligment(pos);
            }
            if (!instance.getTag().equals("style:map")) continue;
            String key = instance.getAttribValue("style:apply-style-name");
            String condition = instance.getAttribValue("style:condition");
            if (key == null || condition == null) continue;
            Style other = this.styles.get(key);
            if (other == null) {
                other = new Style();
                this.styles.put(key, other);
            }
            ConditionalFormat conditionalFormat = new ConditionalFormat(other, condition);
            style.addCondition(conditionalFormat);
        }
        return style;
    }

    private ColumnStyle readColumnStyleEntry(XmlReaderInstance reader) {
        ColumnStyle style = new ColumnStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-column-properties");
            if (instance == null) {
                return style;
            }
            String columnWidth = instance.getAttribValue("style:column-width");
            if (columnWidth == null) continue;
            style.setWidth(columnWidth);
        }
        return style;
    }

    private RowStyle readRowStyleEntry(XmlReaderInstance reader) {
        RowStyle style = new RowStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-row-properties");
            if (instance == null) {
                return style;
            }
            String rowHeight = instance.getAttribValue("style:row-height");
            if (rowHeight == null) continue;
            style.setHeight(rowHeight);
        }
        return style;
    }

    private TableStyle readTableStyleEntry(XmlReaderInstance reader) {
        TableStyle style = new TableStyle();
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("style:table-properties");
            if (instance == null) {
                return style;
            }
            String display = instance.getAttribValue("table:display");
            if (display == null) continue;
            style.setHidden(display.equals("false"));
        }
        return style;
    }

    private void iterateFilesEntries(XmlReaderInstance reader) {
        if (reader == null) {
            return;
        }
        XmlReaderInstance instance = reader.nextElement("office:spreadsheet");
        if (instance != null) {
            this.processSpreadsheet(instance);
        }
    }

    private void processSpreadsheet(XmlReaderInstance reader) {
        while (reader.hasNext()) {
            XmlReaderInstance instance = reader.nextElement("table:table");
            if (instance == null) continue;
            this.processTable(instance);
        }
    }

    private void processTable(XmlReaderInstance reader) {
        String protectedSheet;
        String name = reader.getAttribValue("table:name");
        Sheet sheet = new Sheet(name, 0, 0);
        String tableStyleName = reader.getAttribValue("table:style-name");
        if (tableStyleName != null) {
            this.setTableStyles(sheet, tableStyleName);
        }
        if ((protectedSheet = reader.getAttribValue("table:protected")) != null) {
            String algorithm = reader.getAttribValue("table:protection-key-digest-algorithm");
            if (algorithm == null) {
                algorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            String protectedKey = reader.getAttribValue("table:protection-key");
            sheet.setRawPassword(protectedKey, algorithm);
        }
        int rowCount = 0;
        this.groupCells.clear();
        while (reader.hasNext()) {
            RowStyle rowStyle;
            String rowStyleName;
            XmlReaderInstance instance = reader.nextElement("table:table-column", "table:table-row");
            if (instance == null) continue;
            String styleName = instance.getAttribValue("table:default-cell-style-name");
            Style style = null;
            if (styleName != null) {
                style = this.styles.get(styleName);
            }
            if (instance.getTag().equals("table:table-column")) {
                this.parseColumnProperties(instance, sheet, style);
                continue;
            }
            if (!instance.getTag().equals("table:table-row")) continue;
            if (style != null) {
                this.rows_styles.put(rowCount, style);
            }
            int numRows = 1;
            String numRowsStr = instance.getAttribValue("table:number-rows-repeated");
            if (numRowsStr != null) {
                try {
                    numRows = Integer.parseInt(numRowsStr);
                    if (numRows > 10000) {
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sheet.appendRows(numRows);
            String visibility = instance.getAttribValue("table:visibility");
            if ("collapse".equals(visibility)) {
                sheet.hideRows(sheet.getMaxRows() - numRows, numRows);
            }
            if ((rowStyleName = instance.getAttribValue("table:style-name")) != null && (rowStyle = this.styleRow.get(rowStyleName)) != null) {
                sheet.setRowHeights(sheet.getMaxRows() - numRows, numRows, rowStyle.getHeight());
            }
            this.processCells(instance, sheet, numRows);
        }
        for (Pair<Vector, Vector> pair : this.groupCells) {
            Vector cord = (Vector)pair.first;
            Vector length = (Vector)pair.second;
            Range range = sheet.getRange(cord.getX(), cord.getY(), length.getX(), length.getY());
            range.merge();
        }
        this.spread.appendSheet(sheet);
    }

    private void setTableStyles(Sheet sheet, String tableStyleName) {
        TableStyle style = this.styleTable.get(tableStyleName);
        if (style != null && style.isHidden()) {
            sheet.hideSheet();
        }
    }

    private void parseColumnProperties(XmlReaderInstance instance, Sheet sheet, Style style) {
        ColumnStyle columnStyle;
        String columnStyleName;
        boolean areHidden = false;
        String visibility = instance.getAttribValue("table:visibility");
        if ("collapse".equals(visibility)) {
            areHidden = true;
        }
        int numColumns = 1;
        String columnsRepeated = instance.getAttribValue("table:number-columns-repeated");
        if (columnsRepeated != null && (numColumns = Integer.parseInt(columnsRepeated)) > 10000) {
            return;
        }
        int index = sheet.getMaxColumns();
        sheet.appendColumns(numColumns);
        if (style != null && !style.isDefault()) {
            for (int j = index; j < index + numColumns; ++j) {
                sheet.setDefaultColumnCellStyle(j, style);
                this.columns_styles.put(j, style);
            }
        }
        if (areHidden) {
            sheet.hideColumns(index, numColumns);
        }
        if ((columnStyleName = instance.getAttribValue("table:style-name")) != null && (columnStyle = this.styleColumn.get(columnStyleName)) != null) {
            sheet.setColumnWidths(sheet.getMaxColumns() - numColumns, numColumns, columnStyle.getWidth());
        }
    }

    private void processCells(XmlReaderInstance reader, Sheet sheet, int number_rows_repeated) {
        int column = 0;
        while (reader.hasNext()) {
            int positionY;
            int positionX;
            String columnsSpanned;
            int number_columns_repeated = 1;
            Object last_cell_value = null;
            Object last_style = null;
            XmlReaderInstance instance = reader.nextElement("table:table-cell", "table:covered-table-cell");
            if (instance == null) continue;
            if (instance.getTag().equals("table:covered-table-cell")) {
                String numColumnsRepeated = instance.getAttribValue("table:number-columns-repeated");
                if (numColumnsRepeated == null) {
                    ++column;
                    continue;
                }
                column += Integer.parseInt(numColumnsRepeated);
                continue;
            }
            int rows = 1;
            int columns = 1;
            String rowsSpanned = instance.getAttribValue("table:number-rows-spanned");
            if (rowsSpanned != null) {
                rows = Integer.parseInt(rowsSpanned);
            }
            if ((columnsSpanned = instance.getAttribValue("table:number-columns-spanned")) != null) {
                columns = Integer.parseInt(columnsSpanned);
            }
            if (number_rows_repeated == 1) {
                positionX = sheet.getMaxRows() - 1;
                positionY = column;
                if (rows != 1 || columns != 1) {
                    Pair pair = new Pair();
                    pair.first = new Vector(positionX, positionY);
                    pair.second = new Vector(rows, columns);
                    this.groupCells.add(pair);
                }
            }
            positionX = sheet.getMaxRows() - number_rows_repeated;
            positionY = column;
            OfficeValueType valueType = OfficeValueType.ofReader(instance);
            Object value = valueType.read(instance);
            String raw = instance.getAttribValue("table:number-columns-repeated");
            if (raw != null && (number_columns_repeated = Integer.parseInt(raw)) > 10000) continue;
            if (positionY + number_columns_repeated >= sheet.getMaxColumns()) {
                sheet.appendColumns(positionY + number_columns_repeated - sheet.getMaxColumns());
            }
            Range range = sheet.getRange(positionX, positionY, number_rows_repeated, number_columns_repeated);
            String formula = instance.getAttribValue("table:formula");
            if (formula != null) {
                range.setFormula(formula);
            }
            range.setValue(value);
            Style style = this.styles.get(instance.getAttribValue("table:style-name"));
            if (style == null) {
                style = this.columns_styles.get(column);
            }
            if (style == null) {
                style = this.rows_styles.get(sheet.getMaxRows() - 1);
            }
            if (style != null && !style.isDefault()) {
                range.setStyle(style);
            }
            this.readCellText(instance, range);
            column += number_columns_repeated;
        }
    }

    private void readCellText(XmlReaderInstance cellReader, Range range) {
        StringBuffer s = new StringBuffer();
        XmlReaderInstance textElement = null;
        boolean firstTextElement = true;
        while ((textElement = cellReader.nextElement("text:p", "text:h", "office:annotation")) != null) {
            if (textElement.getTag().equals("office:annotation")) {
                range.setAnnotation(this.getOfficeAnnotation(textElement));
                continue;
            }
            if (firstTextElement) {
                firstTextElement = false;
            } else {
                s.append("\n");
            }
            XmlReaderInstance spanElement = textElement.nextElement("text:s", "characters");
            while (spanElement != null) {
                String spanContent;
                if (spanElement.getTag().equals("text:s")) {
                    int num = 1;
                    String atrib = spanElement.getAttribValue("text:c");
                    if (atrib != null && !atrib.isEmpty()) {
                        try {
                            num = Integer.parseInt(atrib);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invalid number of characters: " + atrib);
                        }
                    }
                    while (num > 0) {
                        s.append(" ");
                        --num;
                    }
                }
                if ((spanContent = spanElement.getContent()) != null) {
                    s.append(spanContent);
                }
                spanElement = textElement.nextElement("text:s", "characters");
            }
        }
        Object value = range.getValue();
        if (s.length() > 0 && (value == null || value instanceof String)) {
            range.setValue(s.toString());
        }
    }

    private OfficeAnnotation getOfficeAnnotation(XmlReaderInstance reader) {
        OfficeAnnotationBuilder annotation = new OfficeAnnotationBuilder();
        StringBuilder msg = new StringBuilder();
        while (reader.hasNext()) {
            String content;
            XmlReaderInstance instance = reader.nextElement("dc:date", "text:p");
            if (instance == null) {
                annotation.setMsg(msg.toString());
                return annotation.build();
            }
            if (instance.getTag().equals("dc:date")) {
                if ((instance = instance.nextElement("characters")) == null) continue;
                content = instance.getContent();
                try {
                    if (content == null) continue;
                    annotation.setLastModified(LocalDateTime.parse(content));
                }
                catch (DateTimeParseException e) {
                    System.err.println("DATE INVALID IN OFFICE ANNOTATION");
                }
                continue;
            }
            if (!instance.getTag().equals("text:p")) continue;
            instance = instance.nextElement("characters");
            if (msg.length() > 0) {
                msg.append("\n");
            }
            if (instance == null) continue;
            content = instance.getContent();
            msg.append(content);
        }
        annotation.setMsg(msg.toString());
        return annotation.build();
    }
}

