/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import standalone_spreadsheet.com.github.miachm.sods.Borders;
import standalone_spreadsheet.com.github.miachm.sods.Cell;
import standalone_spreadsheet.com.github.miachm.sods.Column;
import standalone_spreadsheet.com.github.miachm.sods.Compressor;
import standalone_spreadsheet.com.github.miachm.sods.ConditionalFormat;
import standalone_spreadsheet.com.github.miachm.sods.FileEntry;
import standalone_spreadsheet.com.github.miachm.sods.GenerateOdsException;
import standalone_spreadsheet.com.github.miachm.sods.GroupCell;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotation;
import standalone_spreadsheet.com.github.miachm.sods.OfficeValueType;
import standalone_spreadsheet.com.github.miachm.sods.Row;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;
import standalone_spreadsheet.com.github.miachm.sods.SpreadSheet;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.TableStyle;

class OdsWritter {
    private SpreadSheet spread;
    private Compressor out;
    private Map<Style, String> stylesUsed = new HashMap<Style, String>();
    private Map<Double, String> columnStyleStringMap = new HashMap<Double, String>();
    private Map<Double, String> rowStyleStringMap = new HashMap<Double, String>();
    private Map<TableStyle, String> tableStyleStringMap = new HashMap<TableStyle, String>();
    private final String MIMETYPE = "application/vnd.oasis.opendocument.spreadsheet";

    private OdsWritter(OutputStream o, SpreadSheet spread) {
        this.spread = spread;
        this.out = new Compressor(o);
        spread.trimSheets();
    }

    public static void save(OutputStream out, SpreadSheet spread) throws IOException {
        new OdsWritter(out, spread).save();
    }

    private void save() throws IOException {
        this.writeManifest();
        this.writeMymeType();
        try {
            this.writeSpreadsheet();
            this.writeSettingsStyleFile();
            this.writeExtraFiles();
        }
        catch (XMLStreamException e) {
            throw new GenerateOdsException(e);
        }
        this.out.flush();
        this.out.close();
    }

    private void writeManifest() {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)output, "utf-8"));
            out.writeStartDocument("UTF-8", "1.0");
            out.setPrefix("manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest");
            out.writeNamespace("manifest", "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "version", "1.2");
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "file-entry");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "full-path", "/");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "version", "1.2");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "media-type", "application/vnd.oasis.opendocument.spreadsheet");
            out.writeEndElement();
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "file-entry");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "full-path", "content.xml");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "media-type", "text/xml");
            out.writeEndElement();
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "file-entry");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "full-path", "styles.xml");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "media-type", "text/xml");
            out.writeEndElement();
            for (FileEntry entry : this.spread.getExtraFiles()) {
                out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "file-entry");
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "full-path", entry.path);
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "media-type", entry.mimetype);
                out.writeEndElement();
            }
            out.writeEndElement();
            out.writeEndDocument();
            out.close();
            byte[] bytes = output.toByteArray();
            this.out.addEntry(bytes, "META-INF/manifest.xml");
        }
        catch (IOException | XMLStreamException pce) {
            throw new GenerateOdsException(pce);
        }
    }

    private void writeMymeType() throws IOException {
        this.out.addEntry("application/vnd.oasis.opendocument.spreadsheet".getBytes(), "mimetype");
    }

    private void writeSpreadsheet() throws UnsupportedEncodingException, XMLStreamException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)output, "utf-8"));
        out.writeStartDocument("UTF-8", "1.0");
        out.setPrefix("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-content");
        out.writeNamespace("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        out.writeNamespace("table", "urn:oasis:names:tc:opendocument:xmlns:table:1.0");
        out.writeNamespace("text", "urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        out.writeNamespace("fo", "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0");
        out.writeNamespace("style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0");
        out.writeNamespace("dc", "http://purl.org/dc/elements/1.1/");
        out.writeNamespace("number", "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
        this.writeStyles(out);
        this.writeContent(out);
        out.writeEndElement();
        out.writeEndDocument();
        out.close();
        try {
            this.out.addEntry(output.toByteArray(), "content.xml");
        }
        catch (IOException e) {
            throw new GenerateOdsException(e);
        }
    }

    private void writeSettingsStyleFile() throws UnsupportedEncodingException, XMLStreamException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        XMLStreamWriter out = XMLOutputFactory.newInstance().createXMLStreamWriter(new OutputStreamWriter((OutputStream)output, "utf-8"));
        out.writeStartDocument("UTF-8", "1.0");
        out.setPrefix("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "document-styles");
        out.writeNamespace("office", "urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "version", "1.2");
        out.writeEndElement();
        out.writeEndDocument();
        out.close();
        try {
            this.out.addEntry(output.toByteArray(), "styles.xml");
        }
        catch (IOException e) {
            throw new GenerateOdsException(e);
        }
    }

    private void writeContent(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "body");
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "spreadsheet");
        for (Sheet sheet : this.spread.getSheets()) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "name", sheet.getName());
            if (sheet.isHidden()) {
                TableStyle tableStyle = new TableStyle();
                tableStyle.setHidden(true);
                String name = this.tableStyleStringMap.get(tableStyle);
                if (name != null) {
                    out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", name);
                }
            }
            if (sheet.isProtected()) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected", "true");
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protection-key", sheet.getHashedPassword());
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protection-key-digest-algorithm", sheet.getHashedAlgorithm());
            }
            this.writeColumnsStyles(out, sheet);
            this.writeContent(out, sheet);
            out.writeEndElement();
        }
        out.writeEndElement();
        out.writeEndElement();
    }

    private void writeColumnsStyles(XMLStreamWriter out, Sheet sheet) throws XMLStreamException {
        for (Column column : sheet.columns) {
            String name;
            Style defaultCellStyle;
            String name2;
            Double width;
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-column");
            if (column.num_repeated > 1) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated", "" + column.num_repeated);
            }
            if ((width = column.column_style.getWidth()) != null && (name2 = this.columnStyleStringMap.get(width)) != null) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", name2);
            }
            if (column.column_style.isHidden()) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "visibility", "collapse");
            }
            if (!(defaultCellStyle = column.column_style.getDefaultCellStyleDangerous()).isDefault() && (name = this.stylesUsed.get(defaultCellStyle)) != null) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "default-cell-style-name", name);
            }
            out.writeEndElement();
        }
    }

    private void writeContent(XMLStreamWriter out, Sheet sheet) throws XMLStreamException {
        for (Row row : sheet.rows) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-row");
            if (row.num_repeated > 1) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated", "" + row.num_repeated);
            }
            this.writeRowStyles(out, row);
            for (Cell cell : row.cells) {
                this.writeCell(out, cell);
            }
            out.writeEndElement();
        }
    }

    private void writeRowStyles(XMLStreamWriter out, Row row) throws XMLStreamException {
        if (row.row_style.isHidden()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "visibility", "collapse");
        }
        this.writeRowHeight(out, row);
    }

    private void writeCell(XMLStreamWriter out, Cell cell) throws XMLStreamException {
        String formula = cell.getFormula();
        Style style = cell.getStyle();
        GroupCell group = cell.getGroup();
        if (group != null && group.getCell() != cell) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "covered-table-cell");
            out.writeEndElement();
            return;
        }
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "table-cell");
        if (cell.num_repeated > 1) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated", "" + cell.num_repeated);
        }
        if (group != null) {
            if (group.getLength().getY() > 1) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-spanned", "" + group.getLength().getY());
            }
            if (group.getLength().getX() > 1) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-spanned", "" + group.getLength().getX());
            }
        }
        if (formula != null) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "formula", formula);
        }
        this.setCellStyle(out, style);
        this.writeValue(out, cell);
        out.writeEndElement();
    }

    private void setCellStyle(XMLStreamWriter out, Style style) throws XMLStreamException {
        if (!style.isDefault()) {
            String key = this.stylesUsed.get(style);
            if (key == null) {
                key = "cel" + this.stylesUsed.size();
                this.stylesUsed.put(style, key);
            }
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", key);
        }
    }

    private void writeValue(XMLStreamWriter out, Cell cell) throws XMLStreamException {
        OfficeAnnotation annotation;
        Object v = cell.getValue();
        if (v != null) {
            OfficeValueType valueType = OfficeValueType.ofJavaType(v.getClass());
            if (valueType != OfficeValueType.STRING || cell.getFormula() != null) {
                valueType.write(v, out);
            } else if (valueType == OfficeValueType.STRING) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "value-type", "string");
            }
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
            String text = v.toString();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == ' ') {
                    out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "s");
                    int cnt = 0;
                    while (i + cnt < text.length() && text.charAt(i + cnt) == ' ') {
                        ++cnt;
                    }
                    if (cnt > 1) {
                        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "c", "" + cnt);
                    }
                    i += cnt - 1;
                    out.writeEndElement();
                    continue;
                }
                if (text.charAt(i) == '\t') {
                    out.writeEmptyElement("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "tab");
                    continue;
                }
                if (text.charAt(i) == '\n') {
                    out.writeEndElement();
                    out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
                    continue;
                }
                if (Character.isHighSurrogate(text.charAt(i)) && i + 1 < text.length() && Character.isLowSurrogate(text.charAt(i + 1))) {
                    out.writeCharacters("" + text.charAt(i) + text.charAt(i + 1));
                    ++i;
                    continue;
                }
                out.writeCharacters("" + text.charAt(i));
            }
            out.writeEndElement();
        }
        if ((annotation = cell.getAnnotation()) != null) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "annotation");
            if (annotation.getLastModified() != null) {
                out.writeStartElement("http://purl.org/dc/elements/1.1/", "date");
                out.writeCharacters(annotation.getLastModified().toString());
                out.writeEndElement();
            }
            if (annotation.getMsg() != null) {
                out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
                out.writeCharacters(annotation.getMsg());
                out.writeEndElement();
            }
            out.writeEndElement();
        }
    }

    private void writeRowHeight(XMLStreamWriter out, Row row) throws XMLStreamException {
        String name;
        Double height = row.row_style.getHeight();
        if (height != null && (name = this.rowStyleStringMap.get(height)) != null) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "style-name", name);
        }
    }

    private void writeStyles(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "automatic-styles");
        this.writeDataFormatStyles(out);
        for (Sheet sheet : this.spread.getSheets()) {
            for (Row row : sheet.rows) {
                for (Cell cell : row.cells) {
                    Style style = cell.getStyle();
                    if (style.isDefault()) continue;
                    this.writeCellStyle(out, style);
                }
                Double height = row.row_style.getHeight();
                if (height == null) continue;
                this.writeRowStyle(out, height);
            }
            for (Column column : sheet.columns) {
                Style defaultCellStyle;
                Double width = column.column_style.getWidth();
                if (width != null) {
                    this.writeColumnStyle(out, width);
                }
                if ((defaultCellStyle = column.column_style.getDefaultCellStyleDangerous()).isDefault()) continue;
                this.writeCellStyle(out, defaultCellStyle);
            }
            if (!sheet.isHidden()) continue;
            this.writeTableStyle(out, sheet);
        }
        out.writeEndElement();
    }

    private void writeDataFormatStyles(XMLStreamWriter out) throws XMLStreamException {
        out.writeStartElement("number:text-style");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", "textstyle");
        out.writeEmptyElement("number:text-content");
        out.writeEndElement();
        out.writeStartElement("number:date-style");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", "datestyle");
        out.writeStartElement("number:year");
        out.writeAttribute("number:style", "long");
        out.writeEndElement();
        out.writeStartElement("number:text");
        out.writeCharacters("-");
        out.writeEndElement();
        out.writeStartElement("number:month");
        out.writeAttribute("number:style", "long");
        out.writeEndElement();
        out.writeStartElement("number:text");
        out.writeCharacters("-");
        out.writeEndElement();
        out.writeEmptyElement("number:day");
        out.writeEndElement();
    }

    private void writeCellStyle(XMLStreamWriter out, Style style) throws XMLStreamException {
        String key = this.stylesUsed.get(style);
        if (key == null) {
            key = "cel" + this.stylesUsed.size();
            this.stylesUsed.put(style, key);
            this.writeCellStyle(out, style, key);
        }
    }

    private void writeCellStyle(XMLStreamWriter out, Style style, String key) throws XMLStreamException {
        for (ConditionalFormat conditionalFormat : style.getConditions()) {
            this.writeCellStyle(out, conditionalFormat.getStyleApplied());
        }
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", "table-cell");
        out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", key);
        String dataStyle = style.getDataStyle();
        if ("@".equals(dataStyle)) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "data-style-name", "textstyle");
        } else if ("YYYY-MM-DD".equals(dataStyle)) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "data-style-name", "datestyle");
        }
        if (style.hasTableCellProperties()) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-cell-properties");
            if (style.getBackgroundColor() != null) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "background-color", style.getBackgroundColor().toString());
            }
            if (style.isWrap()) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "wrap-option", "wrap");
            }
            if (style.getVerticalTextAligment() != null) {
                out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "vertical-align", style.getVerticalTextAligment().toString().toLowerCase());
            }
            if (style.hasBorders()) {
                this.writeBorderStyle(out, style);
            }
            out.writeEndElement();
        }
        for (ConditionalFormat format : style.getConditions()) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "map");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "condition", format.getRawCondition());
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "apply-style-name", this.getConditionalFormatName(format.getStyleApplied()));
            out.writeEndElement();
        }
        out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-properties");
        if (style.isItalic()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-style", "italic");
        }
        if (style.isBold()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-weight", "bold");
        }
        if (style.isUnderline()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-style", "solid");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-type", "single");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-width", "auto");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "text-underline-color", "font-color");
        }
        if (style.getFontSize() != -1) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "font-size", "" + style.getFontSize() + "pt");
        }
        if (style.getFontColor() != null) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "color", style.getFontColor().toString());
        }
        out.writeEndElement();
        if (style.getTextAligment() != null) {
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "paragraph-properties");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "text-align", this.toValue(style.getTextAligment()));
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private String getConditionalFormatName(Style style) {
        String key = this.stylesUsed.get(style);
        return key;
    }

    private String toValue(Style.TEXT_ALIGMENT textAligment) {
        switch (textAligment) {
            case Left: {
                return "start";
            }
            case Center: {
                return "center";
            }
            case Right: {
                return "end";
            }
        }
        return null;
    }

    private void writeColumnStyle(XMLStreamWriter out, Double width) throws XMLStreamException {
        if (!this.columnStyleStringMap.containsKey(width)) {
            String key = "co" + this.columnStyleStringMap.size();
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", "table-column");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", key);
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-column-properties");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "column-width", width.toString() + "mm");
            out.writeEndElement();
            out.writeEndElement();
            this.columnStyleStringMap.put(width, key);
        }
    }

    private void writeRowStyle(XMLStreamWriter out, Double height) throws XMLStreamException {
        if (!this.rowStyleStringMap.containsKey(height)) {
            String key = "ro" + this.rowStyleStringMap.size();
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", "table-row");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", key);
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-row-properties");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "row-height", height.toString() + "mm");
            out.writeEndElement();
            out.writeEndElement();
            this.rowStyleStringMap.put(height, key);
        }
    }

    private void writeTableStyle(XMLStreamWriter out, Sheet sheet) throws XMLStreamException {
        TableStyle tableStyle = new TableStyle();
        tableStyle.setHidden(sheet.isHidden());
        if (!this.tableStyleStringMap.containsKey(tableStyle)) {
            String key = "tb" + this.tableStyleStringMap.size();
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "style");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "family", "table");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", key);
            out.writeStartElement("urn:oasis:names:tc:opendocument:xmlns:style:1.0", "table-properties");
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "display", tableStyle.isHidden() ? "false" : "true");
            out.writeEndElement();
            out.writeEndElement();
            this.tableStyleStringMap.put(tableStyle, key);
        }
    }

    private void writeBorderStyle(XMLStreamWriter out, Style style) throws XMLStreamException {
        Borders borders = style.getBorders();
        if (borders.isBorder()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "border", borders.getBorderProperties());
        }
        if (borders.isBorderTop()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "border-top", borders.getBorderTopProperties());
        }
        if (borders.isBorderBottom()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "border-bottom", borders.getBorderBottomProperties());
        }
        if (borders.isBorderLeft()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "border-left", borders.getBorderLeftProperties());
        }
        if (borders.isBorderRight()) {
            out.writeAttribute("urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0", "border-right", borders.getBorderRightProperties());
        }
    }

    private void writeExtraFiles() throws IOException {
        for (FileEntry entry : this.spread.getExtraFiles()) {
            this.out.addEntry(entry.data, entry.path);
        }
    }
}

