/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

public class OfficePercentage {
    private final Double value;

    public OfficePercentage(Double value) {
        this.value = value;
    }

    public OfficePercentage(String value) {
        if (!value.endsWith("%")) {
            throw new IllegalArgumentException("The string representation does not end with a '%'");
        }
        try {
            this.value = Double.parseDouble(value.substring(0, value.length() - 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number", e);
        }
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfficePercentage that = (OfficePercentage)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return "" + this.value * 100.0 + "%";
    }
}

