/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import standalone_spreadsheet.com.github.miachm.sods.A1NotationCord;
import standalone_spreadsheet.com.github.miachm.sods.Cell;
import standalone_spreadsheet.com.github.miachm.sods.Column;
import standalone_spreadsheet.com.github.miachm.sods.ColumnStyle;
import standalone_spreadsheet.com.github.miachm.sods.Pair;
import standalone_spreadsheet.com.github.miachm.sods.Range;
import standalone_spreadsheet.com.github.miachm.sods.Row;
import standalone_spreadsheet.com.github.miachm.sods.RowStyle;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.TableField;

public class Sheet
implements Cloneable,
Comparable<Sheet> {
    List<Column> columns = new ArrayList<Column>();
    List<Row> rows = new ArrayList<Row>();
    private String name;
    private int numColumns = 0;
    private int numRows = 0;
    private boolean isHidden = false;
    private String hashed_password = null;
    private String hash_algorithm = null;

    public Sheet(String name) {
        this(name, 1, 1);
    }

    public Sheet(String name, int rows, int columns) {
        if (rows < 0 || columns < 0) {
            throw new IllegalArgumentException("Rows/Columns can't be negative");
        }
        if (name == null) {
            throw new NullPointerException("The name of the sheet can't be null");
        }
        this.name = name;
        this.appendColumns(columns);
        this.appendRows(rows);
    }

    public void appendRow() {
        this.appendRows(1);
    }

    public void appendRows(int howmany) {
        this.insertRowsAfter(this.getMaxRows() - 1, howmany);
    }

    public void appendColumn() {
        this.appendColumns(1);
    }

    public void appendColumns(int howmany) {
        this.insertColumnsAfter(this.getMaxColumns() - 1, howmany);
    }

    public void clear() {
        this.getDataRange().clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private <T extends TableField> void deleteFields(List<T> fields, int index, int howmany) {
        TableField item;
        Pair<Integer, Integer> pair = this.getIndexDelete(fields, index);
        if (((Integer)pair.first).intValue() == fields.size()) {
            return;
        }
        if ((Integer)pair.second > 0) {
            item = (TableField)fields.get((Integer)pair.first);
            TableField other = (TableField)item.clone();
            int aux = item.num_repeated;
            item.num_repeated = (Integer)pair.second;
            other.num_repeated = aux - (Integer)pair.second;
            fields.add((Integer)pair.first + 1, other);
            Pair<Integer, Integer> pair2 = pair;
            Integer n = (Integer)pair2.first;
            pair2.first = (Integer)pair2.first + 1;
            Integer n2 = pair2.first;
            pair.second = 0;
        }
        while (howmany > 0) {
            item = (TableField)fields.get((Integer)pair.first);
            if (howmany < item.num_repeated) {
                item.num_repeated -= howmany;
                howmany = 0;
                continue;
            }
            howmany -= item.num_repeated;
            fields.remove((Integer)pair.first);
        }
    }

    private <T extends TableField> T getFieldForEditing(List<T> fields, Supplier<T> fieldSupplier, int index) {
        List<T> list = this.getFieldForEditingRange(fields, fieldSupplier, index, 1);
        return (T)((TableField)list.get(0));
    }

    private <T extends TableField> List<T> getFieldForEditingRange(List<T> fields, Supplier<T> fieldSupplier, int index, int howmany) {
        TableField item;
        Integer n;
        Object object;
        Object object2;
        Pair<Integer, Integer> pair = this.getIndexDelete(fields, index);
        if ((Integer)pair.second > 0) {
            TableField item2;
            if (((Integer)pair.first).intValue() == fields.size()) {
                fields.add(fieldSupplier.get());
                item2 = (TableField)fields.get((Integer)pair.first);
                item2.num_repeated = (Integer)pair.second;
                Pair<Integer, Integer> pair2 = pair;
                Integer n2 = (Integer)pair2.first;
                pair2.first = (Integer)pair2.first + 1;
                object2 = pair2.first;
            } else {
                item2 = (TableField)fields.get((Integer)pair.first);
                TableField other = (TableField)item2.clone();
                int aux = item2.num_repeated;
                item2.num_repeated = (Integer)pair.second;
                other.num_repeated = aux - (Integer)pair.second;
                fields.add((Integer)pair.first + 1, other);
                object2 = pair;
                object = (Integer)((Pair)object2).first;
                ((Pair)object2).first = (Integer)((Pair)object2).first + 1;
                n = ((Pair)object2).first;
            }
        }
        ArrayList<TableField> list = new ArrayList<TableField>();
        while (howmany > 0 && (Integer)pair.first < fields.size()) {
            item = (TableField)fields.get((Integer)pair.first);
            if (item.num_repeated == howmany) {
                list.add(item);
                return list;
            }
            if (item.num_repeated < howmany) {
                howmany -= item.num_repeated;
                list.add(item);
                Pair<Integer, Integer> aux = pair;
                object2 = (Integer)aux.first;
                aux.first = (Integer)aux.first + 1;
                object = aux.first;
                continue;
            }
            int aux = item.num_repeated;
            item.num_repeated -= howmany;
            TableField other = (TableField)item.clone();
            other.num_repeated = aux - item.num_repeated;
            list.add(other);
            fields.add((Integer)pair.first, other);
            object = pair;
            n = (Integer)((Pair)object).first;
            ((Pair)object).first = (Integer)((Pair)object).first + 1;
            Integer n3 = ((Pair)object).first;
            howmany = 0;
        }
        if (howmany > 0) {
            item = (TableField)fieldSupplier.get();
            item.num_repeated = howmany;
            fields.add(item);
            list.add(item);
        }
        return list;
    }

    private <T extends TableField> void insertField(List<T> fields, T value, int index) {
        for (int i = 0; i < fields.size(); ++i) {
            TableField item = (TableField)fields.get(i);
            if (index >= item.num_repeated) {
                index -= item.num_repeated;
                continue;
            }
            int cnt = item.num_repeated;
            item.num_repeated -= index;
            fields.add(i, value);
            TableField other = (TableField)item.clone();
            other.num_repeated = cnt - item.num_repeated;
            if (other.num_repeated > 0) {
                fields.add(i + 1, other);
            }
            return;
        }
        fields.add(value);
    }

    public void deleteColumn(int column) {
        this.deleteColumns(column, 1);
    }

    public void deleteColumns(int column, int howmany) {
        if (column < 0) {
            throw new IndexOutOfBoundsException("Column " + column + " is negative");
        }
        if (column + howmany > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + column + " plus " + howmany + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        if (howmany < 0) {
            throw new IllegalArgumentException("The number of columns can't be negative");
        }
        if (howmany == 0) {
            return;
        }
        this.deleteFields(this.columns, column, howmany);
        for (Row row : this.rows) {
            this.deleteFields(row.cells, column, howmany);
        }
        this.numColumns -= howmany;
    }

    public void deleteRow(int row) {
        this.deleteRows(row, 1);
    }

    public void deleteRows(int row, int howmany) {
        if (row + howmany > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + row + " is out of bounds (" + this.getMaxRows() + ")");
        }
        if (row < 0) {
            throw new IndexOutOfBoundsException("Row index can't be negative");
        }
        if (howmany < 0) {
            throw new IllegalArgumentException("The number of rows can't be negative");
        }
        if (howmany == 0) {
            return;
        }
        this.deleteFields(this.rows, row, howmany);
        this.numRows -= howmany;
    }

    public Double getColumnWidth(int column) {
        this.checkColumnRange(column);
        int index = this.getIndex(this.columns, column);
        if (index == this.columns.size()) {
            return ColumnStyle.default_style.getWidth();
        }
        return this.columns.get((int)index).column_style.getWidth();
    }

    public Double getRowHeight(int row) {
        this.checkRowRange(row);
        int index = this.getIndex(this.rows, row);
        if (index == this.rows.size()) {
            return RowStyle.default_style.getHeight();
        }
        return this.rows.get((int)index).row_style.getHeight();
    }

    public Range getDataRange() {
        return this.getRange(0, 0, this.getMaxRows(), this.getMaxColumns());
    }

    public int getMaxColumns() {
        return this.numColumns;
    }

    public int getMaxRows() {
        return this.numRows;
    }

    public String getName() {
        return this.name;
    }

    public Range getRange(int row, int column) {
        return this.getRange(row, column, 1, 1);
    }

    public Range getRange(int row, int column, int numRows) {
        return this.getRange(row, column, numRows, 1);
    }

    public Range getRange(int row, int column, int numRows, int numColumns) {
        return new Range(this, row, column, numRows, numColumns);
    }

    public Range getRange(String a1Notation) {
        A1NotationCord cord = new A1NotationCord(a1Notation);
        int row = cord.getInitRow();
        int column = cord.getInitColumn();
        int numRows = cord.getLastRow() - cord.getInitRow() + 1;
        int numColumns = cord.getLastColumn() - cord.getInitColumn() + 1;
        return this.getRange(row, column, numRows, numColumns);
    }

    private Pair<Integer, Integer> getIndexDelete(List<? extends TableField> fields, int index) {
        for (int i = 0; i < fields.size(); ++i) {
            TableField item = fields.get(i);
            if (index >= item.num_repeated) {
                index -= item.num_repeated;
                continue;
            }
            return new Pair<Integer, Integer>(i, index);
        }
        return new Pair<Integer, Integer>(fields.size(), index);
    }

    private int getIndex(List<? extends TableField> fields, int index) {
        return (Integer)this.getIndexDelete(fields, (int)index).first;
    }

    Cell getCell(int row, int column) {
        Row item = this.getFieldForEditing(this.rows, Row::new, row);
        Cell cell = this.getFieldForEditing(item.cells, Cell::new, column);
        return cell;
    }

    public void hideRow(int row) {
        this.checkRowRange(row);
        Row item = this.getFieldForEditing(this.rows, Row::new, row);
        item.row_style.setHidden(true);
    }

    public void hideRows(int row, int howmany) {
        this.toggleRows(row, howmany, true);
    }

    private void toggleRows(int row, int howmany, boolean hidden) {
        if (howmany < 0) {
            throw new IllegalArgumentException("howmany needs to be positive");
        }
        if (howmany == 0) {
            return;
        }
        this.checkRowRange(row);
        this.checkRowRange(row + howmany - 1);
        List<Row> list = this.getFieldForEditingRange(this.rows, Row::new, row, howmany);
        for (Row item : list) {
            item.row_style.setHidden(hidden);
        }
    }

    public void hideColumn(int column) {
        this.checkColumnRange(column);
        Column item = this.getFieldForEditing(this.columns, Column::new, column);
        item.column_style.setHidden(true);
    }

    public void hideColumns(int column, int howmany) {
        this.toggleColumns(column, howmany, true);
    }

    private void toggleColumns(int column, int howmany, boolean hidden) {
        if (howmany < 0) {
            throw new IllegalArgumentException("howmany needs to be positive");
        }
        if (howmany == 0) {
            return;
        }
        this.checkColumnRange(column);
        this.checkColumnRange(column + howmany - 1);
        List<Column> list = this.getFieldForEditingRange(this.columns, Column::new, column, howmany);
        for (Column item : list) {
            item.column_style.setHidden(hidden);
        }
    }

    public void insertColumnAfter(int afterPosition) {
        this.insertColumnsAfter(afterPosition, 1);
    }

    public void insertColumnBefore(int beforePosition) {
        this.insertColumnsBefore(beforePosition, 1);
    }

    public void insertColumnsAfter(int columnIndex, int howmany) {
        this.insertColumnsBefore(columnIndex + 1, howmany);
    }

    public void insertColumnsBefore(int columnIndex, int howmany) {
        if (columnIndex > this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column " + columnIndex + " is out of bounds (" + this.getMaxColumns() + ")");
        }
        if (howmany < 0) {
            throw new IllegalArgumentException("Number of columns can't be negative");
        }
        if (howmany == 0) {
            return;
        }
        Column column = new Column();
        column.num_repeated = howmany;
        this.insertField(this.columns, column, columnIndex);
        this.numColumns += howmany;
        for (Row row : this.rows) {
            Cell cell = new Cell();
            cell.num_repeated = howmany;
            this.insertField(row.cells, cell, columnIndex);
        }
    }

    public void insertRowAfter(int afterPosition) {
        this.insertRowsAfter(afterPosition, 1);
    }

    public void insertRowBefore(int beforePosition) {
        this.insertRowsBefore(beforePosition, 1);
    }

    public void insertRowsBefore(int rowIndex, int howmany) {
        if (rowIndex > this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row " + rowIndex + " is out of bounds (" + this.getMaxRows() + ")");
        }
        if (howmany < 0) {
            throw new IllegalArgumentException("Number of rows can't be negative");
        }
        if (howmany == 0) {
            return;
        }
        Row row = new Row();
        row.num_repeated = howmany;
        this.insertField(this.rows, row, rowIndex);
        this.numRows += howmany;
    }

    public void insertRowsAfter(int rowIndex, int howmany) {
        this.insertRowsBefore(rowIndex + 1, howmany);
    }

    public void setColumnWidth(int column, Double width) {
        this.checkColumnRange(column);
        if (width != null && width < 0.0) {
            throw new IllegalArgumentException("Width can't be negative!");
        }
        Column item = this.getFieldForEditing(this.columns, Column::new, column);
        item.column_style.setWidth(width);
    }

    public void setColumnWidths(int column, int numColumns, Double width) {
        if (numColumns < 0) {
            throw new IllegalArgumentException("Numcolumns needs to be positive");
        }
        if (numColumns == 0) {
            return;
        }
        this.checkColumnRange(column);
        this.checkColumnRange(column + numColumns - 1);
        List<Column> list = this.getFieldForEditingRange(this.columns, Column::new, column, numColumns);
        for (Column item : list) {
            item.column_style.setWidth(width);
        }
    }

    public void setRowHeight(int row, Double height) {
        this.checkRowRange(row);
        if (height != null && height < 0.0) {
            throw new IllegalArgumentException("Height can't be negative!");
        }
        Row item = this.getFieldForEditing(this.rows, Row::new, row);
        item.row_style.setHeight(height);
    }

    public void setRowHeights(int row, int numRows, Double height) {
        if (numRows < 0) {
            throw new IllegalArgumentException("numRows needs to be positive");
        }
        if (numRows == 0) {
            return;
        }
        this.checkRowRange(row);
        this.checkRowRange(row + numRows - 1);
        List<Row> list = this.getFieldForEditingRange(this.rows, Row::new, row, numRows);
        for (Row item : list) {
            item.row_style.setHeight(height);
        }
    }

    public void showRow(int row) {
        this.checkRowRange(row);
        Row item = this.getFieldForEditing(this.rows, Row::new, row);
        item.row_style.setHidden(false);
    }

    public void showColumn(int column) {
        this.checkColumnRange(column);
        Column item = this.getFieldForEditing(this.columns, Column::new, column);
        item.column_style.setHidden(false);
    }

    public boolean rowIsHidden(int row) {
        this.checkRowRange(row);
        int index = this.getIndex(this.rows, row);
        if (index == this.rows.size()) {
            return RowStyle.default_style.isHidden();
        }
        return this.rows.get((int)index).row_style.isHidden();
    }

    private void checkRowRange(int row) {
        if (row < 0 || row >= this.getMaxRows()) {
            throw new IndexOutOfBoundsException("Row is not a valid position: " + row);
        }
    }

    public boolean columnIsHidden(int column) {
        this.checkColumnRange(column);
        int index = this.getIndex(this.columns, column);
        if (index == this.columns.size()) {
            return ColumnStyle.default_style.isHidden();
        }
        return this.columns.get((int)index).column_style.isHidden();
    }

    private void checkColumnRange(int column) {
        if (column < 0 || column >= this.getMaxColumns()) {
            throw new IndexOutOfBoundsException("Column is not a valid position: " + column);
        }
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void hideSheet() {
        this.isHidden = true;
    }

    public void showSheet() {
        this.isHidden = false;
    }

    public Style getDefaultColumnCellStyle(int column) {
        this.checkColumnRange(column);
        int index = this.getIndex(this.columns, column);
        if (index == this.columns.size()) {
            return ColumnStyle.default_style.getDefaultCellStyleCopy();
        }
        return this.columns.get((int)index).column_style.getDefaultCellStyleCopy();
    }

    public void setDefaultColumnCellStyle(int column, Style defaultColumnCellStyle) {
        this.checkColumnRange(column);
        Column item = this.getFieldForEditing(this.columns, Column::new, column);
        item.column_style.setDefaultCellStyle(defaultColumnCellStyle);
    }

    public int getLastRow() {
        return this.getMaxRows();
    }

    public int getLastColumn() {
        return this.getMaxColumns();
    }

    public void trim() {
        this.trim(this.columns);
        for (Row row : this.rows) {
            this.trim(row.cells);
        }
        this.trim(this.rows);
    }

    private <T extends TableField> void trim(List<T> fields) {
        TableField last_item = null;
        for (int i = 0; i < fields.size(); ++i) {
            TableField item = (TableField)fields.get(i);
            if (last_item != null) {
                if (item.equals(last_item)) {
                    last_item.num_repeated += item.num_repeated;
                    fields.remove(i);
                    --i;
                    continue;
                }
                last_item = item;
                continue;
            }
            last_item = item;
        }
    }

    public boolean isProtected() {
        return this.hashed_password != null;
    }

    public void setPassword(String key) throws NoSuchAlgorithmException {
        if (key == null) {
            this.hashed_password = null;
            this.hash_algorithm = null;
            return;
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key is empty");
        }
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        this.hashed_password = Base64.getEncoder().encodeToString(digest.digest(key.getBytes(StandardCharsets.UTF_8)));
        this.hash_algorithm = "http://www.w3.org/2000/09/xmldsig#sha256";
    }

    void setRawPassword(String hashed_password, String algorithm) {
        if (algorithm == null) {
            algorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        this.hashed_password = hashed_password;
        this.hash_algorithm = algorithm;
    }

    String getHashedPassword() {
        return this.hashed_password;
    }

    String getHashedAlgorithm() {
        return this.hash_algorithm;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sheet sheet = (Sheet)o;
        if (!this.name.equals(sheet.name)) {
            return false;
        }
        if (this.numColumns != sheet.numColumns) {
            return false;
        }
        if (this.numRows != sheet.numRows) {
            return false;
        }
        if (this.isHidden != sheet.isHidden) {
            return false;
        }
        this.trim();
        sheet.trim();
        if (!this.rows.equals(sheet.rows)) {
            return false;
        }
        return this.columns.equals(sheet.columns);
    }

    public int hashCode() {
        int result = this.rows.hashCode();
        result = 31 * result + this.columns.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.numColumns;
        result = 31 * result + this.numRows;
        result = 31 * result + (this.isHidden ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(Sheet o) {
        return this.name.compareTo(o.getName());
    }

    public String toString() {
        return "Sheet{\ndimensions=" + this.getLastRow() + "x" + this.getLastColumn() + ",\nname='" + this.name + '\'' + ",\nishidden=" + this.isHidden + '}';
    }
}

