/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import standalone_spreadsheet.com.github.miachm.sods.Borders;
import standalone_spreadsheet.com.github.miachm.sods.Color;
import standalone_spreadsheet.com.github.miachm.sods.ConditionalFormat;

public final class Style
implements Cloneable {
    static final Style default_style = new Style();
    static final String PLAIN_DATA_STYLE = "@";
    static final String ISO_DATE_DATA_STYLE = "YYYY-MM-DD";
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private Color fontColor;
    private Color backgroundColor;
    private int fontSize = -1;
    private Borders borders = null;
    private boolean wrap = false;
    private TEXT_ALIGMENT horizontal_alignment = null;
    private VERTICAL_TEXT_ALIGMENT vertical_alignment = null;
    private String dataStyle;
    private List<ConditionalFormat> conditionalFormats = new ArrayList<ConditionalFormat>();

    public Style() {
    }

    @Deprecated
    public Style(boolean bold, boolean italic, boolean underline, Color fontColor, Color backgroundColor, int fontSize) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSize;
    }

    @Deprecated
    public Style(boolean bold, boolean italic, boolean underline, Color fontColor, Color backgroundColor, int fontSize, Borders borders, boolean wrap) {
        this.bold = bold;
        this.italic = italic;
        this.underline = underline;
        this.fontColor = fontColor;
        this.backgroundColor = backgroundColor;
        this.fontSize = fontSize;
        this.borders = borders;
        this.wrap = wrap;
    }

    public boolean isDefault() {
        return this.equals(new Style());
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void addCondition(ConditionalFormat format) {
        this.conditionalFormats.add(format);
    }

    public List<ConditionalFormat> getConditions() {
        return this.conditionalFormats;
    }

    public void removeCondition(int i) {
        this.conditionalFormats.remove(i);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public void setFontSize(int fontSize) {
        if (fontSize < -1) {
            throw new IllegalArgumentException("Error, font size can be less of -1");
        }
        this.fontSize = fontSize;
    }

    public Borders getBorders() {
        return this.borders;
    }

    public void setBorders(Borders borders) {
        this.borders = borders;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public boolean hasTableCellProperties() {
        return this.backgroundColor != null || this.hasBorders() || this.wrap || this.vertical_alignment != null;
    }

    public boolean hasBorders() {
        return this.borders != null && this.borders.anyBorder();
    }

    public void setTextAligment(TEXT_ALIGMENT p) {
        this.horizontal_alignment = p;
    }

    public TEXT_ALIGMENT getTextAligment() {
        return this.horizontal_alignment;
    }

    public void setVerticalTextAligment(VERTICAL_TEXT_ALIGMENT p) {
        this.vertical_alignment = p;
    }

    public VERTICAL_TEXT_ALIGMENT getVerticalTextAligment() {
        return this.vertical_alignment;
    }

    public String getDataStyle() {
        return this.dataStyle;
    }

    public void setDataStyle(String dataStyle) {
        if (dataStyle != null && !PLAIN_DATA_STYLE.equals(dataStyle) && !ISO_DATE_DATA_STYLE.equals(dataStyle)) {
            throw new IllegalArgumentException("At the moment, the only supported date styles are null, '@', and 'YYYY-MM-DD', but not '" + dataStyle + "'");
        }
        this.dataStyle = dataStyle;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Style style = (Style)o;
        if (this.bold != style.bold) {
            return false;
        }
        if (this.italic != style.italic) {
            return false;
        }
        if (this.underline != style.underline) {
            return false;
        }
        if (this.fontSize != style.fontSize) {
            return false;
        }
        if (!Objects.equals(this.borders, style.borders)) {
            return false;
        }
        if (this.wrap != style.wrap) {
            return false;
        }
        if (!Objects.equals(this.fontColor, style.fontColor)) {
            return false;
        }
        if (!Objects.equals(this.backgroundColor, style.backgroundColor)) {
            return false;
        }
        if (!Objects.equals(this.dataStyle, style.dataStyle)) {
            return false;
        }
        if (this.horizontal_alignment != style.horizontal_alignment) {
            return false;
        }
        if (!this.conditionalFormats.equals(style.conditionalFormats)) {
            return false;
        }
        return this.vertical_alignment == style.vertical_alignment;
    }

    public int hashCode() {
        int result = this.bold ? 1 : 0;
        result = 31 * result + (this.italic ? 1 : 0);
        result = 31 * result + (this.underline ? 1 : 0);
        result = 31 * result + (this.fontColor != null ? this.fontColor.hashCode() : 0);
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + this.fontSize;
        result = 31 * result + (this.borders != null ? this.borders.hashCode() : 0);
        result = 31 * result + (this.wrap ? 1 : 0);
        result = 31 * result + (this.dataStyle != null ? this.dataStyle.hashCode() : 0);
        result = 31 * result + this.conditionalFormats.hashCode();
        result = 31 * result + (this.horizontal_alignment != null ? this.horizontal_alignment.hashCode() : 0);
        result = 31 * result + (this.vertical_alignment != null ? this.vertical_alignment.hashCode() : 0);
        return result;
    }

    public Map<String, String> getCssStyles() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.isBold()) {
            result.put("font-weight", "bold");
        }
        if (this.isItalic()) {
            result.put("font-style", "italic");
        }
        if (this.isUnderline()) {
            result.put("text-decoration", "underline");
        }
        if (this.getFontSize() != -1) {
            result.put("font-size", "" + this.getFontSize());
        }
        if (this.getFontColor() != null) {
            result.put("color", "" + this.getFontColor().toString() + ";");
        }
        if (this.getBackgroundColor() != null) {
            result.put("background-color", this.getBackgroundColor().toString());
        }
        if (this.hasBorders()) {
            result.putAll(this.borders.getCssStyles());
        }
        if (this.isWrap()) {
            result.put("white-space", "normal");
        }
        if (this.horizontal_alignment != null) {
            result.put("text-align", this.getTextAligment().toString());
        }
        if (this.vertical_alignment != null) {
            result.put("vertical-align", this.getVerticalTextAligment().toString().toLowerCase());
        }
        if (this.dataStyle != null) {
            result.put("data-style", this.dataStyle);
        }
        return result;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        String result = "";
        Map<String, String> styles = this.getCssStyles();
        for (Map.Entry<String, String> style : styles.entrySet()) {
            result = result + prefix + style.getKey() + ": " + style.getValue() + ";\n";
        }
        return result;
    }

    public static enum VERTICAL_TEXT_ALIGMENT {
        Top,
        Middle,
        Bottom;

    }

    public static enum TEXT_ALIGMENT {
        Left,
        Center,
        Right;

    }
}

