/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping;

import java.io.IOException;
import java.io.InputStream;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.ExactIO;
import standalone_spreadsheet.com.github.rzymek.opczip.reader.skipping.Signature;

class ZipReadSpec {
    static final Signature CEN = new Signature(new byte[]{80, 75, 1, 2});
    static final Signature LFH = new Signature(new byte[]{80, 75, 3, 4});
    static final Signature DAT = new Signature(new byte[]{80, 75, 7, 8});
    static final int DATA_DESCRIPTOR_USED = 8;
    static final int LFH_SIZE = 30;
    static final int DAT_SIZE = 16;
    static final int LFH_VER = 4;
    static final int LFH_FLG = 6;
    static final int LFH_HOW = 8;
    static final int LFH_TIM = 10;
    static final int LFH_CRC = 14;
    static final int LFH_SIZ = 18;
    static final int LFH_LEN = 22;
    static final int LFH_NAM = 26;
    static final int LFH_EXT = 28;

    ZipReadSpec() {
    }

    static int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    static long get32(byte[] b, int off) {
        return ((long)ZipReadSpec.get16(b, off) | (long)ZipReadSpec.get16(b, off + 2) << 16) & 0xFFFFFFFFL;
    }

    static byte[] readNBytes(InputStream in, int len) throws IOException {
        byte[] buf = new byte[len];
        int read = ExactIO.readExactly(in, buf, 0, len);
        if (read != len) {
            throw new IOException("unexpected EOF");
        }
        return buf;
    }
}

