/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.internal.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import lombok.NonNull;
import standalone_spreadsheet.internal.io.text.FileSystemExceptions;
import standalone_spreadsheet.nbbrd.io.FileFormatter;
import standalone_spreadsheet.nbbrd.io.WrappedIOException;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;

public final class LockingFileFormatter<T>
implements FileFormatter<T> {
    @NonNull
    private final FileFormatter<T> delegate;

    @Override
    public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try (FileOutputStream stream = new FileOutputStream(FileSystemExceptions.checkTarget(target));){
            try (FileLock ignore = stream.getChannel().lock();){
                this.delegate.formatStream(value, stream);
            }
            catch (OverlappingFileLockException ex) {
                throw WrappedIOException.wrap(ex);
            }
        }
    }

    @Override
    public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try (FileChannel channel = FileChannel.open(FileSystemExceptions.checkTarget(target), StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            try (FileLock ignore = channel.lock();){
                this.delegate.formatStream(value, Channels.newOutputStream(channel));
            }
            catch (OverlappingFileLockException ex) {
                throw WrappedIOException.wrap(ex);
            }
        }
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.delegate.formatStream(value, target);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        this.delegate.formatStream(value, resource);
    }

    @Generated
    public LockingFileFormatter(@NonNull FileFormatter<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }
}

